/*
 * Decompiled with CFR 0.152.
 */
package plugins.script;

import freemind.common.TextTranslator;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.common.dialogs.EnterPasswordDialog;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SignedScriptHandler {
    public static final String FREEMIND_SCRIPT_KEY_NAME = "FreeMindScriptKey";
    private static final String SIGN_PREFIX = "//SIGN:";
    private static final String SIGN_PREFIX_REGEXP = "//SIGN\\((.*?)\\):(.*)";
    private static KeyStore mKeyStore = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeKeystore(char[] pPassword) {
        if (mKeyStore != null) {
            return;
        }
        FileInputStream fis = null;
        try {
            mKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(System.getProperty("user.home") + File.separator + ".keystore");
            mKeyStore.load(fis, pPassword);
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Resources.getInstance().logException((Throwable)e);
                }
            }
        }
    }

    public String signScript(String pScript, TextTranslator pTranslator, FreeMindMain pFrame) {
        ScriptContents content = new ScriptContents(pScript);
        EnterPasswordDialog pwdDialog = new EnterPasswordDialog(pFrame.getJFrame(), pTranslator, false);
        pwdDialog.setModal(true);
        pwdDialog.setVisible(true);
        if (pwdDialog.getResult() == -1) {
            return content.mScript;
        }
        char[] password = pwdDialog.getPassword().toString().toCharArray();
        this.initializeKeystore(password);
        try {
            Signature instance = Signature.getInstance("SHA1withDSA");
            String keyName = FREEMIND_SCRIPT_KEY_NAME;
            String propertyKeyName = Resources.getInstance().getProperty("resources_script_user_key_name_for_signing");
            if (content.mKeyName != null) {
                keyName = content.mKeyName;
            } else if (propertyKeyName != null && propertyKeyName.length() > 0) {
                keyName = content.mKeyName = propertyKeyName;
            }
            instance.initSign((PrivateKey)mKeyStore.getKey(keyName, password));
            instance.update(content.mScript.getBytes());
            byte[] signature = instance.sign();
            content.mSignature = Tools.toBase64((byte[])signature);
            return content.toString();
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
            pFrame.getController().errorMessage((Object)e.getLocalizedMessage());
            return content.mScript;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isScriptSigned(String pScript, OutputStream pOutStream) {
        ScriptContents content = new ScriptContents(pScript);
        if (content.mSignature == null) return false;
        try {
            Signature instanceVerify = Signature.getInstance("SHA1withDSA");
            if (content.mKeyName == null) {
                String cer = "-----BEGIN CERTIFICATE-----\nMIIDKDCCAuWgAwIBAgIESAY2ADALBgcqhkjOOAQDBQAwdzELMAkGA1UEBhMCREUxCzAJBgNVBAgTAkRFMRMwEQYDVQQHEwpPcGVuU291cmNlMRgwFgYDVQQKEw9zb3VyY2Vmb3JnZS5uZXQxETAPBgNVBAsTCEZyZWVNaW5kMRkwFwYDVQQDExBDaHJpc3RpYW4gRm9sdGluMB4XDTA4MDQxNjE3MjMxMloXDTA4MDcxNTE3MjMxMlowdzELMAkGA1UEBhMCREUxCzAJBgNVBAgTAkRFMRMwEQYDVQQHEwpPcGVuU291cmNlMRgwFgYDVQQKEw9zb3VyY2Vmb3JnZS5uZXQxETAPBgNVBAsTCEZyZWVNaW5kMRkwFwYDVQQDExBDaHJpc3RpYW4gRm9sdGluMIIBtzCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYQAAoGAZm5z5EZXVhtye5jY3X9w24DJ3yNJbNl2tfkOBIc0KfgyxONTSJKtUpmLI3btUxy3pQf/T8BShlY3PAC0fp3MeDG8WRq1wM3luLd1V9SS8EG6tPJBZ3mciCUymTT7n9CZNzATIpqNIXHSD/wljRABedUi8PMg4KbVPnhu6Y6b1uAwCwYHKoZIzjgEAwUAAzAAMC0CFQCFHGwe+HHOvY0MmKYHbiq7fRxMGwIUC0voAGYUu6vgVFqdLI5F96JLTqk=\n-----END CERTIFICATE-----\n";
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> c = cf.generateCertificates(new ByteArrayInputStream(cer.getBytes()));
                Iterator<? extends Certificate> i = c.iterator();
                if (!i.hasNext()) throw new IllegalArgumentException("Internal certificate wrong.");
                Certificate cert = i.next();
                instanceVerify.initVerify(cert);
            } else {
                this.initializeKeystore(null);
                instanceVerify.initVerify(mKeyStore.getCertificate(content.mKeyName));
            }
            instanceVerify.update(content.mScript.getBytes());
            return instanceVerify.verify(Tools.fromBase64((String)content.mSignature));
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
            try {
                pOutStream.write(e.toString().getBytes());
                pOutStream.write("\n".getBytes());
                return false;
            }
            catch (Exception e1) {
                Resources.getInstance().logException((Throwable)e1);
            }
        }
        return false;
    }

    public static class ScriptContents {
        public String mScript;
        public String mSignature;
        public String mKeyName;
        private static Pattern sSignWithKeyPattern = null;

        public ScriptContents() {
            if (sSignWithKeyPattern == null) {
                sSignWithKeyPattern = Pattern.compile(SignedScriptHandler.SIGN_PREFIX_REGEXP);
            }
        }

        public ScriptContents(String pScript) {
            this();
            int indexOfSignaturePrefix = pScript.lastIndexOf(SignedScriptHandler.SIGN_PREFIX);
            int indexOfSignature = indexOfSignaturePrefix + SignedScriptHandler.SIGN_PREFIX.length();
            if (indexOfSignaturePrefix > 0 && pScript.length() > indexOfSignature) {
                this.mSignature = pScript.substring(indexOfSignature);
                this.mScript = pScript.substring(0, indexOfSignaturePrefix);
                this.mKeyName = null;
            } else {
                Matcher matcher = sSignWithKeyPattern.matcher(pScript);
                if (matcher.find()) {
                    this.mScript = pScript.substring(0, matcher.start());
                    this.mKeyName = matcher.group(1);
                    this.mSignature = matcher.group(2);
                } else {
                    this.mSignature = null;
                    this.mScript = pScript;
                    this.mKeyName = null;
                }
            }
        }

        public String toString() {
            String prefix = this.mKeyName != null ? "//SIGN(" + this.mKeyName + "):" : SignedScriptHandler.SIGN_PREFIX;
            return this.mScript + prefix + this.mSignature + "\n";
        }
    }
}

