/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.attributeactors;

import freemind.controller.filter.util.SortedComboBoxModel;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.Attribute;
import freemind.modes.attributes.AttributeController;
import freemind.modes.attributes.AttributeRegistry;
import freemind.modes.attributes.AttributeRegistryElement;
import freemind.modes.attributes.NodeAttributeTableModel;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.attributeactors.InsertAttributeActor;
import freemind.modes.mindmapmode.attributeactors.RegistryAttributeActor;
import freemind.modes.mindmapmode.attributeactors.RegistryAttributeValueActor;
import freemind.modes.mindmapmode.attributeactors.RemoveAttributeActor;
import freemind.modes.mindmapmode.attributeactors.ReplaceAttributeValueActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeColumnWidthActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeFontSizeActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeNameActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeRestrictedActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeValueActor;
import freemind.modes.mindmapmode.attributeactors.SetAttributeVisibleActor;
import freemind.modes.mindmapmode.attributeactors.UnregistryAttributeActor;
import freemind.modes.mindmapmode.attributeactors.UnregistryAttributeValueActor;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class MindMapModeAttributeController
implements AttributeController {
    SetAttributeNameActor setAttributeNameActor;
    SetAttributeValueActor setAttributeValueActor;
    RemoveAttributeActor removeAttributeActor;
    InsertAttributeActor insertAttributeActor;
    SetAttributeColumnWidthActor setAttributeColumnWidthActor;
    RegistryAttributeActor registryAttributeActor;
    UnregistryAttributeActor unregistryAttributeActor;
    RegistryAttributeValueActor registryAttributeValueActor;
    UnregistryAttributeValueActor unregistryAttributeValueActor;
    ReplaceAttributeValueActor replaceAttributeValueActor;
    SetAttributeFontSizeActor setAttributeFontSizeActor;
    SetAttributeVisibleActor setAttributeVisibleActor;
    SetAttributeRestrictedActor setAttributeRestrictedActor;
    private MindMapController controller;

    public MindMapModeAttributeController(MindMapController controller) {
        this.controller = controller;
        this.setAttributeNameActor = new SetAttributeNameActor(controller);
        this.setAttributeValueActor = new SetAttributeValueActor(controller);
        this.removeAttributeActor = new RemoveAttributeActor(controller);
        this.insertAttributeActor = new InsertAttributeActor(controller);
        this.setAttributeColumnWidthActor = new SetAttributeColumnWidthActor(controller);
        this.registryAttributeActor = new RegistryAttributeActor(controller);
        this.unregistryAttributeActor = new UnregistryAttributeActor(controller);
        this.registryAttributeValueActor = new RegistryAttributeValueActor(controller);
        this.replaceAttributeValueActor = new ReplaceAttributeValueActor(controller);
        this.unregistryAttributeValueActor = new UnregistryAttributeValueActor(controller);
        this.setAttributeFontSizeActor = new SetAttributeFontSizeActor(controller);
        this.setAttributeVisibleActor = new SetAttributeVisibleActor(controller);
        this.setAttributeRestrictedActor = new SetAttributeRestrictedActor(controller);
    }

    @Override
    public void performSetValueAt(NodeAttributeTableModel model, Object o, int row, int col) {
        Attribute attribute = model.getAttribute(row);
        AttributeRegistry attributes = this.getAttributeRegistry();
        switch (col) {
            case 0: {
                String name = o.toString().trim();
                if (attribute.getName().equals(name)) {
                    return;
                }
                this.controller.doTransaction("setAttributeNameActionPair", this.setAttributeNameActor.createActionPair(model, row, name));
                try {
                    AttributeRegistryElement element = attributes.getElement((Comparable)((Object)name));
                    String value = model.getValueAt(row, 1).toString();
                    int index = element.getValues().getIndexOf(value);
                    if (index != -1) break;
                    ActionPair setAttributeValueActionPair = this.setAttributeValueActor.createActionPair(model, row, element.getValues().firstElement().toString());
                    this.controller.doTransaction("setAttributeValueActionPair", setAttributeValueActionPair);
                }
                catch (NoSuchElementException ex) {
                    this.controller.doTransaction("registryAttributeActionPair", this.registryAttributeActor.createActionPair(name));
                    this.controller.getActionFactory().doTransaction("setAttributeValueActionPair", this.setAttributeValueActor.createActionPair(model, row, ""));
                }
                break;
            }
            case 1: {
                String value = o.toString().trim();
                if (attribute.getValue().equals(value)) {
                    return;
                }
                ActionPair setValueActionPair = this.setAttributeValueActor.createActionPair(model, row, value);
                this.controller.doTransaction("setValueActionPair", setValueActionPair);
                String name = model.getValueAt(row, 0).toString();
                AttributeRegistryElement element = attributes.getElement((Comparable)((Object)name));
                int index = element.getValues().getIndexOf(value);
                if (index != -1) break;
                ActionPair registryAttributeValueActionPair = this.registryAttributeValueActor.createActionPair(name, value);
                this.controller.doTransaction("registryAttributeValueActionPair", registryAttributeValueActionPair);
                break;
            }
        }
    }

    @Override
    public void performInsertRow(NodeAttributeTableModel model, int row, String name, String value) {
        AttributeRegistry attributes = this.getAttributeRegistry();
        if (name.equals("")) {
            return;
        }
        try {
            AttributeRegistryElement element = attributes.getElement((Comparable)((Object)name));
            int index = element.getValues().getIndexOf(value);
            if (index == -1) {
                if (element.isRestricted()) {
                    value = element.getValues().firstElement().toString();
                } else {
                    ActionPair registryNewAttributeActionPair = this.registryAttributeValueActor.createActionPair(name, value);
                    this.controller.doTransaction("performInsertRow", registryNewAttributeActionPair);
                }
            }
        }
        catch (NoSuchElementException ex) {
            this.controller.doTransaction("performInsertRow", this.registryAttributeActor.createActionPair(name));
            this.controller.doTransaction("registryAttributeValueActor", this.registryAttributeValueActor.createActionPair(name, value));
        }
        ActionPair insertAttributeActionPair = this.insertAttributeActor.createActionPair(model, row, name, value);
        this.controller.doTransaction("insertAttributeActionPair", insertAttributeActionPair);
    }

    @Override
    public void performRemoveRow(NodeAttributeTableModel model, int row) {
        this.controller.doTransaction("performRemoveRow", this.removeAttributeActor.createActionPair(model, row));
    }

    @Override
    public void performSetColumnWidth(NodeAttributeTableModel model, int col, int width) {
        if (width == model.getLayout().getColumnWidth(col)) {
            return;
        }
        this.controller.doTransaction("performSetColumnWidth", this.setAttributeColumnWidthActor.createActionPair(model, col, width));
    }

    @Override
    public void performRemoveAttributeValue(String name, String value) {
        this.controller.doTransaction("removeAttributeActionPair", this.unregistryAttributeValueActor.createActionPair(name, value));
        AttributeValueRemover remover = new AttributeValueRemover(name, value);
        Iterator iterator = new Iterator(remover);
        MindMapNode root = this.controller.getRootNode();
        iterator.iterate(root);
    }

    @Override
    public void performReplaceAttributeValue(String name, String oldValue, String newValue) {
        this.controller.doTransaction("replaceAttributeActionPair", this.replaceAttributeValueActor.createActionPair(name, oldValue, newValue));
        AttributeChanger replacer = new AttributeChanger(name, oldValue, newValue);
        Iterator iterator = new Iterator(replacer);
        MindMapNode root = this.controller.getRootNode();
        iterator.iterate(root);
    }

    @Override
    public void performSetFontSize(AttributeRegistry registry, int size) {
        if (size == registry.getFontSize()) {
            return;
        }
        this.controller.doTransaction("setFontSizeActionPair", this.setAttributeFontSizeActor.createActionPair(size));
    }

    @Override
    public void performSetVisibility(int index, boolean isVisible) {
        if (this.getAttributeRegistry().getElement(index).isVisible() == isVisible) {
            return;
        }
        this.controller.doTransaction("setVisibilityActionPair", this.setAttributeVisibleActor.createActionPair(index, isVisible));
    }

    @Override
    public void performSetRestriction(int index, boolean isRestricted) {
        boolean currentValue = index == -1 ? this.getAttributeRegistry().isRestricted() : this.getAttributeRegistry().getElement(index).isRestricted();
        if (currentValue == isRestricted) {
            return;
        }
        this.controller.doTransaction("setRestrictionActionPair", this.setAttributeRestrictedActor.createActionPair(index, isRestricted));
    }

    @Override
    public void performReplaceAtributeName(String oldName, String newName) {
        if (oldName.equals("") || newName.equals("") || oldName.equals(newName)) {
            return;
        }
        AttributeRegistry registry = this.getAttributeRegistry();
        int iOld = registry.getElements().indexOf((Comparable)((Object)oldName));
        AttributeRegistryElement oldElement = registry.getElement(iOld);
        SortedComboBoxModel values = oldElement.getValues();
        this.controller.doTransaction("registryNewAttributeActionPair", this.registryAttributeActor.createActionPair(newName));
        for (int i = 0; i < values.getSize(); ++i) {
            this.controller.doTransaction("registryNewAttributeValueActionPair", this.registryAttributeValueActor.createActionPair(newName, values.getElementAt(i).toString()));
        }
        AttributeRenamer replacer = new AttributeRenamer(oldName, newName);
        Iterator iterator = new Iterator(replacer);
        MindMapNode root = this.controller.getRootNode();
        iterator.iterate(root);
        this.controller.doTransaction("unregistryOldAttributeActionPair", this.unregistryAttributeActor.createActionPair(oldName));
    }

    @Override
    public void performRemoveAttribute(String name) {
        this.controller.doTransaction("unregistryOldAttributeActionPair", this.unregistryAttributeActor.createActionPair(name));
        AttributeRemover remover = new AttributeRemover(name);
        Iterator iterator = new Iterator(remover);
        MindMapNode root = this.controller.getRootNode();
        iterator.iterate(root);
    }

    @Override
    public void performRegistryAttribute(String name) {
        if (name.equals("")) {
            return;
        }
        try {
            AttributeRegistryElement element = this.getAttributeRegistry().getElement((Comparable)((Object)name));
        }
        catch (NoSuchElementException ex) {
            this.controller.doTransaction("registryNewAttributeActionPair", this.registryAttributeActor.createActionPair(name));
            return;
        }
    }

    @Override
    public void performRegistryAttributeValue(String name, String value) {
        if (name.equals("")) {
            return;
        }
        try {
            AttributeRegistryElement element = this.getAttributeRegistry().getElement((Comparable)((Object)name));
            if (element.getValues().contains(value)) {
                return;
            }
            this.controller.doTransaction("registryNewAttributeActionPair", this.registryAttributeValueActor.createActionPair(name, value));
            return;
        }
        catch (NoSuchElementException ex) {
            this.controller.doTransaction("registryAttributeActionPair", this.registryAttributeActor.createActionPair(name));
            this.controller.doTransaction("registryAttributeValueActionPair", this.registryAttributeValueActor.createActionPair(name, value));
            return;
        }
    }

    private AttributeRegistry getAttributeRegistry() {
        return this.controller.getMap().getRegistry().getAttributes();
    }

    @Override
    public void performRegistrySubtreeAttributes(MindMapNodeModel node) {
        for (int i = 0; i < node.getAttributes().getRowCount(); ++i) {
            String name = node.getAttributes().getValueAt(i, 0).toString();
            String value = node.getAttributes().getValueAt(i, 1).toString();
            this.performRegistryAttributeValue(name, value);
        }
        ListIterator e = node.childrenUnfolded();
        while (e.hasNext()) {
            MindMapNodeModel child = (MindMapNodeModel)e.next();
            this.performRegistrySubtreeAttributes(child);
        }
    }

    private static class Iterator {
        private Visitor visitor;

        Iterator(Visitor v) {
            this.visitor = v;
        }

        void iterate(MindMapNode node) {
            this.visitor.visit(node.getAttributes());
            ListIterator iterator = node.childrenUnfolded();
            while (iterator.hasNext()) {
                MindMapNode child = (MindMapNode)iterator.next();
                this.iterate(child);
            }
        }
    }

    private class AttributeValueRemover
    implements Visitor {
        private Object name;
        private Object value;

        public AttributeValueRemover(Object name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.name) || !model.getValue(i).equals(this.value)) continue;
                ActionPair removeAttributeActionPair = MindMapModeAttributeController.this.removeAttributeActor.createActionPair(model, i);
                MindMapModeAttributeController.this.controller.doTransaction("removeAttributeActionPair", removeAttributeActionPair);
            }
        }
    }

    private class AttributeRemover
    implements Visitor {
        private Object name;

        public AttributeRemover(Object name) {
            this.name = name;
        }

        @Override
        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.name)) continue;
                ActionPair removeAttributeActionPair = MindMapModeAttributeController.this.removeAttributeActor.createActionPair(model, i);
                MindMapModeAttributeController.this.controller.doTransaction("removeAttributeActionPair", removeAttributeActionPair);
            }
        }
    }

    private class AttributeChanger
    implements Visitor {
        private Object name;
        private Object oldValue;
        private Object newValue;

        public AttributeChanger(Object name, Object oldValue, Object newValue) {
            this.name = name;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.name) || !model.getValue(i).equals(this.oldValue)) continue;
                ActionPair setAttributeValueActionPair = MindMapModeAttributeController.this.setAttributeValueActor.createActionPair(model, i, this.newValue.toString());
                MindMapModeAttributeController.this.controller.doTransaction("setAttributeValueActionPair", setAttributeValueActionPair);
            }
        }
    }

    private class AttributeRenamer
    implements Visitor {
        private Object oldName;
        private Object newName;

        public AttributeRenamer(Object oldName, Object newName) {
            this.newName = newName;
            this.oldName = oldName;
        }

        @Override
        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.oldName)) continue;
                ActionPair setAttributeNameActionPair = MindMapModeAttributeController.this.setAttributeNameActor.createActionPair(model, i, this.newName.toString());
                MindMapModeAttributeController.this.controller.doTransaction("setAttributeNameActionPair", setAttributeNameActionPair);
            }
        }
    }

    private static interface Visitor {
        public void visit(NodeAttributeTableModel var1);
    }
}

