/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class PsiArrayAccessExpressionImpl
extends ExpressionPsiElement
implements PsiArrayAccessExpression,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiArrayAccessExpressionImpl");

    public PsiArrayAccessExpressionImpl() {
        super(ARRAY_ACCESS_EXPRESSION);
    }

    @Override
    @NotNull
    public PsiExpression getArrayExpression() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(88);
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiArrayAccessExpressionImpl", "getArrayExpression"));
        }
        return psiExpression;
    }

    @Override
    public PsiExpression getIndexExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(89);
    }

    @Override
    public PsiType getType() {
        PsiType arrayType = this.getArrayExpression().getType();
        if (!(arrayType instanceof PsiArrayType)) {
            return null;
        }
        PsiType componentType = ((PsiArrayType)arrayType).getComponentType();
        if (PsiUtil.isAccessedForWriting(this)) {
            return componentType;
        }
        return PsiUtil.captureToplevelWildcards(componentType, this);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 88: {
                return this.getFirstChildNode();
            }
            case 89: {
                ASTNode lbracket = this.findChildByRole(74);
                if (lbracket == null) {
                    return null;
                }
                for (ASTNode child = lbracket.getTreeNext(); child != null; child = child.getTreeNext()) {
                    if (!EXPRESSION_BIT_SET.contains(child.getElementType())) continue;
                    return child;
                }
                return null;
            }
            case 74: {
                return this.findChildByType(LBRACKET);
            }
            case 75: 
        }
        return this.findChildByType(RBRACKET);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == LBRACKET) {
            return 74;
        }
        if (i == RBRACKET) {
            return 75;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return child == this.getFirstChildNode() ? 88 : 89;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiArrayAccessExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitArrayAccessExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiArrayAccessExpression:" + this.getText();
    }
}

