/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeReconstructionResult;
import org.jetbrains.kotlin.types.TypeUtils;

public class PossiblyBareType {
    private final KotlinType actualType;
    private final TypeConstructor bareTypeConstructor;
    private final boolean nullable;

    @NotNull
    public static PossiblyBareType bare(@NotNull TypeConstructor bareTypeConstructor, boolean nullable) {
        if (bareTypeConstructor == null) {
            PossiblyBareType.$$$reportNull$$$0(0);
        }
        PossiblyBareType possiblyBareType = new PossiblyBareType(null, bareTypeConstructor, nullable);
        if (possiblyBareType == null) {
            PossiblyBareType.$$$reportNull$$$0(1);
        }
        return possiblyBareType;
    }

    @NotNull
    public static PossiblyBareType type(@NotNull KotlinType actualType) {
        if (actualType == null) {
            PossiblyBareType.$$$reportNull$$$0(2);
        }
        PossiblyBareType possiblyBareType = new PossiblyBareType(actualType, null, false);
        if (possiblyBareType == null) {
            PossiblyBareType.$$$reportNull$$$0(3);
        }
        return possiblyBareType;
    }

    private PossiblyBareType(@Nullable KotlinType actualType, @Nullable TypeConstructor bareTypeConstructor, boolean nullable) {
        this.actualType = actualType;
        this.bareTypeConstructor = bareTypeConstructor;
        this.nullable = nullable;
    }

    public boolean isBare() {
        return this.actualType == null;
    }

    @NotNull
    public KotlinType getActualType() {
        KotlinType kotlinType = this.actualType;
        if (kotlinType == null) {
            PossiblyBareType.$$$reportNull$$$0(4);
        }
        return kotlinType;
    }

    @NotNull
    public TypeConstructor getBareTypeConstructor() {
        TypeConstructor typeConstructor2 = this.bareTypeConstructor;
        if (typeConstructor2 == null) {
            PossiblyBareType.$$$reportNull$$$0(5);
        }
        return typeConstructor2;
    }

    private boolean isBareTypeNullable() {
        return this.nullable;
    }

    public boolean isNullable() {
        if (this.isBare()) {
            return this.isBareTypeNullable();
        }
        return this.getActualType().isMarkedNullable();
    }

    public PossiblyBareType makeNullable() {
        if (this.isBare()) {
            return this.isBareTypeNullable() ? this : PossiblyBareType.bare(this.getBareTypeConstructor(), true);
        }
        return PossiblyBareType.type(TypeUtils.makeNullable(this.getActualType()));
    }

    @NotNull
    public TypeReconstructionResult reconstruct(@NotNull KotlinType subjectType) {
        if (subjectType == null) {
            PossiblyBareType.$$$reportNull$$$0(6);
        }
        if (!this.isBare()) {
            TypeReconstructionResult typeReconstructionResult = new TypeReconstructionResult(this.getActualType(), true);
            if (typeReconstructionResult == null) {
                PossiblyBareType.$$$reportNull$$$0(7);
            }
            return typeReconstructionResult;
        }
        TypeReconstructionResult reconstructionResult = CastDiagnosticsUtil.findStaticallyKnownSubtype(TypeUtils.makeNotNullable(subjectType), this.getBareTypeConstructor());
        KotlinType type2 = reconstructionResult.getResultingType();
        if (type2 == null) {
            TypeReconstructionResult typeReconstructionResult = reconstructionResult;
            if (typeReconstructionResult == null) {
                PossiblyBareType.$$$reportNull$$$0(8);
            }
            return typeReconstructionResult;
        }
        KotlinType resultingType = TypeUtils.makeNullableAsSpecified(type2, this.isBareTypeNullable());
        TypeReconstructionResult typeReconstructionResult = new TypeReconstructionResult(resultingType, reconstructionResult.isAllArgumentsInferred());
        if (typeReconstructionResult == null) {
            PossiblyBareType.$$$reportNull$$$0(9);
        }
        return typeReconstructionResult;
    }

    public String toString() {
        return this.isBare() ? "bare " + this.bareTypeConstructor + (this.isBareTypeNullable() ? "?" : "") : this.getActualType().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bareTypeConstructor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/PossiblyBareType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subjectType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/PossiblyBareType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "bare";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "type";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBareTypeConstructor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "reconstruct";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bare";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reconstruct";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

