/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DirectoryFileSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.OutputType;
import org.gradle.api.internal.tasks.ResolvedTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.TaskOutputPackerUtils;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginMetadata;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginReader;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginWriter;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarTaskOutputPacker
implements TaskOutputPacker {
    private static final String METADATA_PATH = "METADATA";
    private static final Pattern PROPERTY_PATH = Pattern.compile("(missing-)?property-([^/]+)(?:/(.*))?");
    private static final int FILE_PERMISSION_MASK = 511;
    private static final int BUFFER_SIZE = 65536;
    private static final ThreadLocal<byte[]> COPY_BUFFERS = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[65536];
        }
    };
    private final FileSystem fileSystem;
    private final StreamHasher streamHasher;
    private final StringInterner stringInterner;

    public TarTaskOutputPacker(FileSystem fileSystem, StreamHasher streamHasher, StringInterner stringInterner) {
        this.fileSystem = fileSystem;
        this.streamHasher = streamHasher;
        this.stringInterner = stringInterner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskOutputPacker.PackResult pack(SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, Map<String, Map<String, FileContentSnapshot>> outputSnapshots, OutputStream output, TaskOutputOriginWriter writeOrigin) throws IOException {
        BufferedOutputStream bufferedOutput = output instanceof BufferedOutputStream ? (BufferedOutputStream)output : new BufferedOutputStream(output);
        TarArchiveOutputStream tarOutput = new TarArchiveOutputStream((OutputStream)bufferedOutput, "utf-8");
        try {
            tarOutput.setLongFileMode(3);
            tarOutput.setBigNumberMode(2);
            tarOutput.setAddPaxHeadersForNonAsciiNames(true);
            this.packMetadata(writeOrigin, tarOutput);
            long entryCount = this.pack(propertySpecs, outputSnapshots, tarOutput);
            TaskOutputPacker.PackResult packResult = new TaskOutputPacker.PackResult(entryCount + 1L);
            return packResult;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)tarOutput);
        }
    }

    private void packMetadata(TaskOutputOriginWriter writeMetadata, TarArchiveOutputStream tarOutput) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writeMetadata.execute(baos);
        TarTaskOutputPacker.createTarEntry(METADATA_PATH, baos.size(), 33188, tarOutput);
        tarOutput.write(baos.toByteArray());
        tarOutput.closeArchiveEntry();
    }

    private long pack(Collection<ResolvedTaskOutputFilePropertySpec> propertySpecs, Map<String, Map<String, FileContentSnapshot>> outputSnapshots, TarArchiveOutputStream tarOutput) {
        long entries = 0L;
        for (ResolvedTaskOutputFilePropertySpec propertySpec : propertySpecs) {
            String propertyName = propertySpec.getPropertyName();
            Map<String, FileContentSnapshot> outputs = outputSnapshots.get(propertyName);
            try {
                entries += this.packProperty(propertySpec, outputs, tarOutput);
            }
            catch (Exception ex) {
                throw new GradleException(String.format("Could not pack property '%s': %s", propertyName, ex.getMessage()), (Throwable)ex);
            }
        }
        return entries;
    }

    private long packProperty(CacheableTaskOutputFilePropertySpec propertySpec, Map<String, FileContentSnapshot> outputSnapshots, TarArchiveOutputStream tarOutput) throws IOException {
        String propertyName = propertySpec.getPropertyName();
        File root = propertySpec.getOutputFile();
        if (root == null) {
            return 0L;
        }
        String propertyPath = "property-" + propertyName;
        if (outputSnapshots.isEmpty()) {
            this.storeMissingProperty(propertyPath, tarOutput);
            return 1L;
        }
        switch (propertySpec.getOutputType()) {
            case DIRECTORY: {
                return this.storeDirectoryProperty(propertyPath, root, outputSnapshots, tarOutput);
            }
            case FILE: {
                this.storeFileProperty(propertyPath, root, tarOutput);
                return 1L;
            }
        }
        throw new AssertionError();
    }

    private long storeDirectoryProperty(String propertyPath, File directory, Map<String, FileContentSnapshot> outputSnapshots, TarArchiveOutputStream tarOutput) throws IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.format("Expected '%s' to be a directory", directory));
        }
        long entries = 0L;
        String propertyRoot = propertyPath + "/";
        TarTaskOutputPacker.createTarEntry(propertyRoot, 0L, 16877, tarOutput);
        tarOutput.closeArchiveEntry();
        ++entries;
        String rootAbsolutePath = directory.getAbsolutePath();
        Path rootPath = directory.toPath();
        for (Map.Entry<String, FileContentSnapshot> entry : outputSnapshots.entrySet()) {
            String absolutePath = entry.getKey();
            if (absolutePath.equals(rootAbsolutePath)) continue;
            File file = new File(absolutePath);
            String relativePath = rootPath.relativize(file.toPath()).toString();
            String targetPath = propertyRoot + relativePath;
            int mode = this.fileSystem.getUnixMode(file);
            switch (entry.getValue().getType()) {
                case RegularFile: {
                    this.storeFileEntry(file, targetPath, file.length(), mode, tarOutput);
                    break;
                }
                case Directory: {
                    this.storeDirectoryEntry(targetPath, mode, tarOutput);
                    break;
                }
                case Missing: {
                    throw new IllegalStateException("File should not be missing: " + file);
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++entries;
        }
        return entries;
    }

    private void storeFileProperty(String propertyPath, File file, TarArchiveOutputStream tarOutput) throws IOException {
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format("Expected '%s' to be a file", file));
        }
        this.storeFileEntry(file, propertyPath, file.length(), this.fileSystem.getUnixMode(file), tarOutput);
    }

    private void storeMissingProperty(String propertyPath, TarArchiveOutputStream tarOutput) throws IOException {
        TarTaskOutputPacker.createTarEntry("missing-" + propertyPath, 0L, 33188, tarOutput);
        tarOutput.closeArchiveEntry();
    }

    private void storeDirectoryEntry(String path, int mode, TarArchiveOutputStream tarOutput) throws IOException {
        TarTaskOutputPacker.createTarEntry(path + "/", 0L, 0x4000 | mode, tarOutput);
        tarOutput.closeArchiveEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeFileEntry(File inputFile, String path, long size, int mode, TarArchiveOutputStream tarOutput) throws IOException {
        TarTaskOutputPacker.createTarEntry(path, size, 0x8000 | mode, tarOutput);
        FileInputStream input = new FileInputStream(inputFile);
        try {
            IOUtils.copyLarge((InputStream)input, (OutputStream)tarOutput, (byte[])COPY_BUFFERS.get());
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        tarOutput.closeArchiveEntry();
    }

    private static void createTarEntry(String path, long size, int mode, TarArchiveOutputStream tarOutput) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(path, true);
        entry.setSize(size);
        entry.setMode(mode);
        tarOutput.putArchiveEntry((ArchiveEntry)entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskOutputPacker.UnpackResult unpack(SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, InputStream input, TaskOutputOriginReader readOrigin) throws IOException {
        TarArchiveInputStream tarInput = new TarArchiveInputStream(input);
        try {
            TaskOutputPacker.UnpackResult unpackResult = this.unpack(propertySpecs, tarInput, readOrigin);
            return unpackResult;
        }
        finally {
            IOUtils.closeQuietly((InputStream)tarInput);
        }
    }

    private TaskOutputPacker.UnpackResult unpack(SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, TarArchiveInputStream tarInput, TaskOutputOriginReader readOriginAction) throws IOException {
        TarArchiveEntry tarEntry;
        ImmutableMap propertySpecsMap = Maps.uniqueIndex(propertySpecs, (Function)new Function<TaskFilePropertySpec, String>(){

            public String apply(TaskFilePropertySpec propertySpec) {
                return propertySpec.getPropertyName();
            }
        });
        TaskOutputOriginMetadata originMetadata = null;
        ImmutableListMultimap.Builder propertyFileSnapshots = ImmutableListMultimap.builder();
        long entries = 0L;
        while ((tarEntry = tarInput.getNextTarEntry()) != null) {
            ++entries;
            String name = tarEntry.getName();
            if (name.equals(METADATA_PATH)) {
                originMetadata = readOriginAction.execute((InputStream)new CloseShieldInputStream((InputStream)tarInput));
                continue;
            }
            Matcher matcher = PROPERTY_PATH.matcher(name);
            if (!matcher.matches()) {
                throw new IllegalStateException("Cached result format error, invalid contents: " + name);
            }
            String propertyName = matcher.group(2);
            ResolvedTaskOutputFilePropertySpec propertySpec = (ResolvedTaskOutputFilePropertySpec)propertySpecsMap.get(propertyName);
            if (propertySpec == null) {
                throw new IllegalStateException(String.format("No output property '%s' registered", propertyName));
            }
            boolean outputMissing = matcher.group(1) != null;
            String childPath = matcher.group(3);
            this.unpackPropertyEntry(propertySpec, (InputStream)tarInput, tarEntry, childPath, outputMissing, (ImmutableMultimap.Builder<String, FileSnapshot>)propertyFileSnapshots);
        }
        if (originMetadata == null) {
            throw new IllegalStateException("Cached result format error, no origin metadata was found.");
        }
        return new TaskOutputPacker.UnpackResult(originMetadata, entries, (ImmutableListMultimap<String, FileSnapshot>)propertyFileSnapshots.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackPropertyEntry(ResolvedTaskOutputFilePropertySpec propertySpec, InputStream input, TarArchiveEntry entry, String childPath, boolean missing, ImmutableMultimap.Builder<String, FileSnapshot> fileSnapshots) throws IOException {
        RelativePath relativePath;
        File outputFile;
        File propertyRoot = propertySpec.getOutputFile();
        String propertyName = propertySpec.getPropertyName();
        if (propertyRoot == null) {
            throw new IllegalStateException("Optional property should have a value: " + propertyName);
        }
        boolean isDirEntry = entry.isDirectory();
        boolean root = Strings.isNullOrEmpty((String)childPath);
        if (root) {
            if (missing) {
                if (!TaskOutputPackerUtils.makeDirectory(propertyRoot.getParentFile()) && propertyRoot.exists()) {
                    FileUtils.forceDelete((File)propertyRoot);
                }
                return;
            }
            OutputType outputType = propertySpec.getOutputType();
            if (isDirEntry) {
                if (outputType != OutputType.DIRECTORY) {
                    throw new IllegalStateException("Property should be an output directory property: " + propertyName);
                }
            } else if (outputType == OutputType.DIRECTORY) {
                throw new IllegalStateException("Property should be an output file property: " + propertyName);
            }
            TaskOutputPackerUtils.ensureDirectoryForProperty(outputType, propertyRoot);
            outputFile = propertyRoot;
        } else {
            outputFile = new File(propertyRoot, childPath);
        }
        String internedPath = this.stringInterner.intern(outputFile.getAbsolutePath());
        RelativePath relativePath2 = root ? RelativePath.parse((!isDirEntry ? 1 : 0) != 0, (String)outputFile.getName()) : (relativePath = RelativePath.parse((!isDirEntry ? 1 : 0) != 0, (String)childPath));
        if (isDirEntry) {
            FileUtils.forceMkdir((File)outputFile);
            fileSnapshots.put((Object)propertyName, (Object)new DirectoryFileSnapshot(internedPath, relativePath, root));
        } else {
            HashCode hash;
            FileOutputStream output = new FileOutputStream(outputFile);
            try {
                hash = this.streamHasher.hashCopy(input, (OutputStream)output);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
            FileHashSnapshot contentSnapshot = new FileHashSnapshot(hash, outputFile.lastModified());
            fileSnapshots.put((Object)propertyName, (Object)new RegularFileSnapshot(internedPath, relativePath, root, contentSnapshot));
        }
        this.fileSystem.chmod(outputFile, entry.getMode() & 0x1FF);
    }
}

