/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import org.gradle.api.internal.tasks.testing.detection.AbstractTestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.detection.TestClassVisitor;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestClassDetecter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestNGDetector
extends AbstractTestFrameworkDetector<TestNGTestClassDetecter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestNGDetector.class);

    TestNGDetector(ClassFileExtractionManager classFileExtractionManager) {
        super(classFileExtractionManager);
    }

    @Override
    protected TestNGTestClassDetecter createClassVisitor() {
        return new TestNGTestClassDetecter(this);
    }

    @Override
    protected boolean processTestClass(File testClassFile, boolean superClass) {
        TestClassVisitor classVisitor = this.classVisitor(testClassFile);
        boolean isTest = classVisitor.isTest();
        if (!isTest) {
            String superClassName = classVisitor.getSuperClassName();
            File superClassFile = this.getSuperTestClassFile(superClassName);
            if (superClassFile != null) {
                isTest = this.processSuperClass(superClassFile);
            } else {
                LOGGER.debug("test-class-scan : failed to scan parent class {}, could not find the class file", (Object)superClassName);
            }
        }
        this.publishTestClass(isTest, classVisitor, superClass);
        return isTest;
    }
}

