/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public class PluginManagerException
extends Exception {
    private final String pluginGroupId;
    private final String pluginArtifactId;
    private final String pluginVersion;
    private String goal;
    private MavenProject project;

    protected PluginManagerException(Plugin plugin, String message, MavenProject project, Throwable cause) {
        super(message, cause);
        this.project = project;
        this.pluginGroupId = plugin.getGroupId();
        this.pluginArtifactId = plugin.getArtifactId();
        this.pluginVersion = plugin.getVersion();
    }

    public PluginManagerException(Plugin plugin, String message, Throwable cause) {
        super(message, cause);
        this.pluginGroupId = plugin.getGroupId();
        this.pluginArtifactId = plugin.getArtifactId();
        this.pluginVersion = plugin.getVersion();
    }

    protected PluginManagerException(MojoDescriptor mojoDescriptor, String message, Throwable cause) {
        super(message, cause);
        this.pluginGroupId = mojoDescriptor.getPluginDescriptor().getGroupId();
        this.pluginArtifactId = mojoDescriptor.getPluginDescriptor().getArtifactId();
        this.pluginVersion = mojoDescriptor.getPluginDescriptor().getVersion();
        this.goal = mojoDescriptor.getGoal();
    }

    protected PluginManagerException(MojoDescriptor mojoDescriptor, MavenProject project, String message) {
        super(message);
        this.project = project;
        this.pluginGroupId = mojoDescriptor.getPluginDescriptor().getGroupId();
        this.pluginArtifactId = mojoDescriptor.getPluginDescriptor().getArtifactId();
        this.pluginVersion = mojoDescriptor.getPluginDescriptor().getVersion();
        this.goal = mojoDescriptor.getGoal();
    }

    protected PluginManagerException(MojoDescriptor mojoDescriptor, MavenProject project, String message, Throwable cause) {
        super(message, cause);
        this.project = project;
        this.pluginGroupId = mojoDescriptor.getPluginDescriptor().getGroupId();
        this.pluginArtifactId = mojoDescriptor.getPluginDescriptor().getArtifactId();
        this.pluginVersion = mojoDescriptor.getPluginDescriptor().getVersion();
        this.goal = mojoDescriptor.getGoal();
    }

    public PluginManagerException(Plugin plugin, InvalidVersionSpecificationException cause) {
        super((Throwable)cause);
        this.pluginGroupId = plugin.getGroupId();
        this.pluginArtifactId = plugin.getArtifactId();
        this.pluginVersion = plugin.getVersion();
    }

    public PluginManagerException(Plugin plugin, String message, PlexusConfigurationException cause) {
        super(message, cause);
        this.pluginGroupId = plugin.getGroupId();
        this.pluginArtifactId = plugin.getArtifactId();
        this.pluginVersion = plugin.getVersion();
    }

    public PluginManagerException(Plugin plugin, String message, ComponentRepositoryException cause) {
        super(message, (Throwable)cause);
        this.pluginGroupId = plugin.getGroupId();
        this.pluginArtifactId = plugin.getArtifactId();
        this.pluginVersion = plugin.getVersion();
    }

    public PluginManagerException(MojoDescriptor mojoDescriptor, MavenProject project, String message, NoSuchRealmException cause) {
        super(message, (Throwable)cause);
        this.project = project;
        this.pluginGroupId = mojoDescriptor.getPluginDescriptor().getGroupId();
        this.pluginArtifactId = mojoDescriptor.getPluginDescriptor().getArtifactId();
        this.pluginVersion = mojoDescriptor.getPluginDescriptor().getVersion();
        this.goal = mojoDescriptor.getGoal();
    }

    public PluginManagerException(MojoDescriptor mojoDescriptor, String message, MavenProject project, PlexusContainerException cause) {
        super(message, (Throwable)cause);
        this.project = project;
        PluginDescriptor pd = mojoDescriptor.getPluginDescriptor();
        this.pluginGroupId = pd.getGroupId();
        this.pluginArtifactId = pd.getArtifactId();
        this.pluginVersion = pd.getVersion();
        this.goal = mojoDescriptor.getGoal();
    }

    public PluginManagerException(Plugin plugin, String message, PlexusContainerException cause) {
        super(message, (Throwable)cause);
        this.pluginGroupId = plugin.getGroupId();
        this.pluginArtifactId = plugin.getArtifactId();
        this.pluginVersion = plugin.getVersion();
    }

    public PluginManagerException(Plugin plugin, String message, MavenProject project) {
        super(message);
        this.pluginGroupId = plugin.getGroupId();
        this.pluginArtifactId = plugin.getArtifactId();
        this.pluginVersion = plugin.getVersion();
        this.project = project;
    }

    public String getPluginGroupId() {
        return this.pluginGroupId;
    }

    public String getPluginArtifactId() {
        return this.pluginArtifactId;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public String getGoal() {
        return this.goal;
    }

    public MavenProject getProject() {
        return this.project;
    }
}

