/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.TreeMap;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.text.TreeFormatter;

public class NoMatchingConfigurationSelectionException
extends RuntimeException {
    public NoMatchingConfigurationSelectionException(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentResolveMetadata targetComponent) {
        super(NoMatchingConfigurationSelectionException.generateMessage(fromConfigurationAttributes, attributeMatcher, targetComponent));
    }

    private static String generateMessage(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentResolveMetadata targetComponent) {
        TreeMap<String, ConfigurationMetadata> configurations = new TreeMap<String, ConfigurationMetadata>();
        for (ConfigurationMetadata configurationMetadata : targetComponent.getVariantsForGraphTraversal()) {
            configurations.put(configurationMetadata.getName(), configurationMetadata);
        }
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Unable to find a matching configuration of " + targetComponent.getComponentId().getDisplayName());
        formatter.startChildren();
        if (configurations.isEmpty()) {
            formatter.node("None of the consumable configurations have attributes.");
        } else {
            for (ConfigurationMetadata configuration : configurations.values()) {
                AmbiguousConfigurationSelectionException.formatConfiguration(formatter, fromConfigurationAttributes, attributeMatcher, configuration);
            }
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

