/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.support;

import grails.util.BuildSettings;
import grails.util.GrailsStringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.grails.plugins.support.WatchPattern;
import org.springframework.util.StringUtils;

public class WatchPatternParser {
    public static final String WILD_CARD = "*";

    public List<WatchPattern> getWatchPatterns(List<String> patterns) {
        ArrayList<WatchPattern> watchPatterns = new ArrayList<WatchPattern>();
        for (String pattern : patterns) {
            WatchPattern watchPattern = new WatchPattern();
            watchPattern.setPattern(pattern);
            boolean isClasspath = false;
            if (pattern.startsWith("file:")) {
                pattern = pattern.substring("file:".length());
            } else if (pattern.startsWith("classpath:")) {
                pattern = pattern.substring("classpath:".length());
                isClasspath = true;
            }
            if (pattern.contains(WILD_CARD)) {
                String dirPath = pattern.substring(0, pattern.indexOf(WILD_CARD));
                if (!GrailsStringUtils.isBlank(dirPath)) {
                    watchPattern.setDirectory(new File(dirPath));
                } else if (isClasspath && BuildSettings.BASE_DIR != null) {
                    watchPattern.setDirectory(new File(BuildSettings.BASE_DIR, "src/main/resources"));
                }
                this.setExtension(pattern, watchPattern);
                watchPatterns.add(watchPattern);
                continue;
            }
            this.setExtension(pattern, watchPattern);
            watchPattern.setFile(new File(pattern));
            watchPatterns.add(watchPattern);
        }
        return watchPatterns;
    }

    private void setExtension(String pattern, WatchPattern watchPattern) {
        int i = pattern.lastIndexOf(42);
        if (i > -1) {
            String extension = pattern.substring(i + 1, pattern.length());
            if (extension.startsWith(".")) {
                extension = extension.substring(1);
            }
            watchPattern.setExtension(extension);
        } else {
            String ext = StringUtils.getFilenameExtension((String)pattern);
            if (ext != null) {
                watchPattern.setExtension(ext);
            }
        }
    }
}

