/*
 * Decompiled with CFR 0.152.
 */
package org.grails.buffer;

import java.io.Writer;
import org.grails.buffer.GrailsPrintWriter;
import org.grails.buffer.StreamCharBuffer;
import org.grails.encoder.EncodedAppender;
import org.grails.encoder.EncodedAppenderFactory;
import org.grails.encoder.Encoder;
import org.grails.encoder.EncoderAware;
import org.grails.encoder.EncodingStateRegistry;

public class CodecPrintWriter
extends GrailsPrintWriter
implements EncoderAware,
EncodedAppenderFactory {
    private final Encoder encoder;
    private final StreamCharBuffer buffer;
    private boolean ignoreEncodingState;

    public CodecPrintWriter(Writer out, Encoder encoder, EncodingStateRegistry encodingStateRegistry) {
        this(out, encoder, encodingStateRegistry, false);
    }

    public CodecPrintWriter(Writer out, Encoder encoder, EncodingStateRegistry encodingStateRegistry, boolean ignoreEncodingState) {
        super(null);
        this.encoder = encoder;
        this.buffer = new StreamCharBuffer();
        this.buffer.setNotifyParentBuffersEnabled(false);
        this.allowUnwrappingOut = false;
        this.buffer.connectTo(out, false);
        if (out instanceof EncodedAppenderFactory) {
            this.buffer.setWriteDirectlyToConnectedMinSize(0);
            this.buffer.setChunkMinSize(0);
        }
        this.setOut(this.buffer.getWriterForEncoder(encoder, encodingStateRegistry, ignoreEncodingState));
    }

    @Override
    public Encoder getEncoder() {
        return this.encoder;
    }

    @Override
    public EncodedAppender getEncodedAppender() {
        EncodedAppender encodedAppender = ((EncodedAppenderFactory)((Object)this.buffer.getWriter())).getEncodedAppender();
        encodedAppender.setIgnoreEncodingState(this.ignoreEncodingState);
        return encodedAppender;
    }

    @Override
    public Writer getWriterForEncoder(Encoder encoder, EncodingStateRegistry encodingStateRegistry) {
        return this.buffer.getWriterForEncoder(encoder, encodingStateRegistry, this.ignoreEncodingState);
    }
}

