/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.json.parser;

final class StringUnmarshaller {
    private StringUnmarshaller() {
    }

    static String unmarshall(String str) {
        str = str.substring(1, str.length() - 1);
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            ++i;
            if (c == '\\') {
                char c1 = str.charAt(i);
                ++i;
                if (c1 == 'u') {
                    int codePoint = StringUnmarshaller.getCodePoint(str, i);
                    sb.appendCodePoint(codePoint);
                    i += 4;
                    continue;
                }
                char escapedChar = StringUnmarshaller.getEscapedChar(str, c1);
                sb.append(escapedChar);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static int getCodePoint(String str, int i) {
        String s = str.substring(i, i + 4);
        return Integer.parseInt(s, 16);
    }

    private static char getEscapedChar(String str, char c) {
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '\\': {
                return '\\';
            }
            case '/': {
                return '/';
            }
        }
        throw new IllegalStateException("Unexpected character: " + c + " in " + str);
    }
}

