/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.io.Serializable;
import java.util.Hashtable;

public class Modifiers
implements Serializable {
    public static final int CLASS = 0;
    public static final int METHOD = 1;
    public static final int FIELD = 2;
    Hashtable modifiers;

    public void addModifier(int n, String string) {
        Class<Void> clazz;
        if (this.modifiers == null) {
            this.modifiers = new Hashtable();
        }
        if ((clazz = this.modifiers.put(string, Void.TYPE)) != null) {
            throw new IllegalStateException("Duplicate modifier: " + string);
        }
        int n2 = 0;
        if (this.hasModifier("private")) {
            ++n2;
        }
        if (this.hasModifier("protected")) {
            ++n2;
        }
        if (this.hasModifier("public")) {
            ++n2;
        }
        if (n2 > 1) {
            throw new IllegalStateException("public/private/protected cannot be used in combination.");
        }
        switch (n) {
            case 0: {
                this.validateForClass();
                break;
            }
            case 1: {
                this.validateForMethod();
                break;
            }
            case 2: {
                this.validateForField();
            }
        }
    }

    public boolean hasModifier(String string) {
        if (this.modifiers == null) {
            this.modifiers = new Hashtable();
        }
        return this.modifiers.get(string) != null;
    }

    private void validateForMethod() {
        this.insureNo("volatile", "Method");
        this.insureNo("transient", "Method");
    }

    private void validateForField() {
        this.insureNo("synchronized", "Variable");
        this.insureNo("native", "Variable");
        this.insureNo("abstract", "Variable");
    }

    private void validateForClass() {
        this.validateForMethod();
        this.insureNo("native", "Class");
        this.insureNo("synchronized", "Class");
    }

    private void insureNo(String string, String string2) {
        if (this.hasModifier(string)) {
            throw new IllegalStateException(string2 + " cannot be declared '" + string + "'");
        }
    }

    public String toString() {
        return "Modifiers: " + this.modifiers;
    }
}

