/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRule;

public class ParserRuleSet {
    private static final ParserRuleSet[] standard = new ParserRuleSet[19];
    private final String modeName;
    private final String setName;
    private Hashtable<String, String> props;
    private KeywordMap keywords;
    private int ruleCount;
    private final Map<Character, List<ParserRule>> ruleMap;
    private final List<ParserRuleSet> imports;
    private int terminateChar = -1;
    private boolean ignoreCase = true;
    private byte defaultToken;
    private ParserRule escapeRule;
    private boolean highlightDigits;
    private Pattern digitRE;
    private String _noWordSep;
    private String noWordSep;
    private boolean builtIn;

    public static ParserRuleSet getStandardRuleSet(byte by) {
        return standard[by];
    }

    public ParserRuleSet(String string, String string2) {
        this.modeName = string;
        this.setName = string2;
        this.ruleMap = new HashMap<Character, List<ParserRule>>();
        this.imports = new ArrayList<ParserRuleSet>();
    }

    public String getModeName() {
        return this.modeName;
    }

    public String getSetName() {
        return this.setName;
    }

    public String getName() {
        return this.modeName + "::" + this.setName;
    }

    public Hashtable<String, String> getProperties() {
        return this.props;
    }

    public void setProperties(Hashtable<String, String> hashtable) {
        this.props = hashtable;
        this._noWordSep = null;
    }

    public void resolveImports() {
        for (ParserRuleSet parserRuleSet : this.imports) {
            if (!parserRuleSet.imports.isEmpty()) {
                parserRuleSet.imports.remove(this);
                parserRuleSet.resolveImports();
            }
            for (List<ParserRule> list : parserRuleSet.ruleMap.values()) {
                for (ParserRule parserRule : list) {
                    this.addRule(parserRule);
                }
            }
            if (parserRuleSet.keywords == null) continue;
            if (this.keywords == null) {
                this.keywords = new KeywordMap(this.ignoreCase);
            }
            this.keywords.add(parserRuleSet.keywords);
        }
        this.imports.clear();
    }

    public void addRuleSet(ParserRuleSet parserRuleSet) {
        this.imports.add(parserRuleSet);
    }

    public void addRule(ParserRule parserRule) {
        Character[] characterArray;
        ++this.ruleCount;
        if (null == parserRule.upHashChars) {
            characterArray = new Character[1];
            characterArray[0] = null == parserRule.upHashChar || 0 >= parserRule.upHashChar.length ? null : Character.valueOf(parserRule.upHashChar[0]);
        } else {
            characterArray = new Character[parserRule.upHashChars.length];
            int n = 0;
            char[] cArray = parserRule.upHashChars;
            int n2 = cArray.length;
            for (int i = 0; i < n2; ++i) {
                char c = cArray[i];
                characterArray[n++] = Character.valueOf(c);
            }
        }
        for (Character c : characterArray) {
            List<ParserRule> list = this.ruleMap.get(c);
            if (null == list) {
                list = new ArrayList<ParserRule>();
                this.ruleMap.put(c, list);
            }
            list.add(parserRule);
        }
    }

    public List<ParserRule> getRules(Character c) {
        boolean bl;
        List<ParserRule> list = this.ruleMap.get(null);
        boolean bl2 = list == null || list.isEmpty();
        Character c2 = c == null ? null : Character.valueOf(Character.toUpperCase(c.charValue()));
        List<ParserRule> list2 = c2 == null ? null : this.ruleMap.get(c2);
        boolean bl3 = bl = list2 == null || list2.isEmpty();
        if (bl2 && bl) {
            return Collections.emptyList();
        }
        if (bl) {
            return list;
        }
        if (bl2) {
            return list2;
        }
        int n = list.size() + list2.size();
        ArrayList<ParserRule> arrayList = new ArrayList<ParserRule>(n);
        arrayList.addAll(list2);
        arrayList.addAll(list);
        return arrayList;
    }

    public int getRuleCount() {
        return this.ruleCount;
    }

    public int getTerminateChar() {
        return this.terminateChar;
    }

    public void setTerminateChar(int n) {
        this.terminateChar = n >= 0 ? n : -1;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public KeywordMap getKeywords() {
        return this.keywords;
    }

    public void setKeywords(KeywordMap keywordMap) {
        this.keywords = keywordMap;
        this._noWordSep = null;
    }

    public boolean getHighlightDigits() {
        return this.highlightDigits;
    }

    public void setHighlightDigits(boolean bl) {
        this.highlightDigits = bl;
    }

    public Pattern getDigitRegexp() {
        return this.digitRE;
    }

    public void setDigitRegexp(Pattern pattern) {
        this.digitRE = pattern;
    }

    public ParserRule getEscapeRule() {
        return this.escapeRule;
    }

    public void setEscapeRule(ParserRule parserRule) {
        this.escapeRule = parserRule;
    }

    public byte getDefault() {
        return this.defaultToken;
    }

    public void setDefault(byte by) {
        this.defaultToken = by;
    }

    public String getNoWordSep() {
        if (this._noWordSep == null) {
            this._noWordSep = this.noWordSep;
            if (this.noWordSep == null) {
                this.noWordSep = "";
            }
            if (this.keywords != null) {
                this.noWordSep = this.noWordSep + this.keywords.getNonAlphaNumericChars();
            }
        }
        return this.noWordSep;
    }

    public void setNoWordSep(String string) {
        this.noWordSep = string;
        this._noWordSep = null;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.modeName + "::" + this.setName + ']';
    }

    static {
        for (byte by = 0; by < 19; by = (byte)(by + 1)) {
            ParserRuleSet.standard[by] = new ParserRuleSet(null, null);
            standard[by].setDefault(by);
            ParserRuleSet.standard[by].builtIn = true;
        }
    }
}

