/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.bufferio.IoTask;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class TextAreaTransferHandler
extends TransferHandler {
    private static JEditTextArea dragSource;
    private static boolean compoundEdit;
    private static boolean sameTextArea;
    private static int insertPos;
    private static int insertOffset;

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        Log.log(1, this, "createTransferable()");
        JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
        if (jEditTextArea.getSelectionCount() == 0) {
            return null;
        }
        dragSource = jEditTextArea;
        return new TextAreaSelection(jEditTextArea);
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        boolean bl;
        Log.log(1, this, "Import data");
        if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            return false;
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                bl = this.importFile(jComponent, transferable);
            } else {
                DataFlavor[] dataFlavorArray;
                DataFlavor dataFlavor = null;
                for (DataFlavor dataFlavor2 : dataFlavorArray = transferable.getTransferDataFlavors()) {
                    if (!this.isUriList(dataFlavor2)) continue;
                    dataFlavor = dataFlavor2;
                    break;
                }
                bl = dataFlavor != null && transferable.isDataFlavorSupported(dataFlavor) ? this.importURIList(jComponent, transferable, dataFlavor) : this.importText(jComponent, transferable);
            }
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
            bl = false;
        }
        GUIUtilities.getView(jComponent).toFront();
        GUIUtilities.getView(jComponent).requestFocus();
        jComponent.requestFocus();
        return bl;
    }

    private boolean importFile(JComponent jComponent, Transferable transferable) throws Exception {
        Log.log(1, this, "=> File list");
        EditPane editPane = (EditPane)GUIUtilities.getComponentParent(jComponent, EditPane.class);
        View view = editPane.getView();
        Buffer buffer = null;
        List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        boolean bl = false;
        BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
        for (File file : list) {
            if (file.isDirectory()) {
                if (bl) continue;
                VFSBrowser.browseDirectory(view, file.getPath());
                bl = true;
                continue;
            }
            Buffer buffer2 = jEdit.openFile(editPane, file.getPath());
            if (buffer2 == null) continue;
            buffer = buffer2;
            bufferSetManager.addBuffer(editPane, buffer);
        }
        if (buffer != null) {
            editPane.setBuffer(buffer);
        }
        view.toFront();
        view.requestFocus();
        editPane.requestFocus();
        return true;
    }

    private boolean importURIList(JComponent jComponent, Transferable transferable, DataFlavor dataFlavor) throws Exception {
        String string = (String)transferable.getTransferData(dataFlavor);
        Log.log(1, this, "=> URIList \"" + string + '\"');
        EditPane editPane = (EditPane)GUIUtilities.getComponentParent(jComponent, EditPane.class);
        View view = editPane.getView();
        JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
        if (dragSource == null) {
            boolean bl = false;
            String[] stringArray = string.split("\r\n");
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                int n = string2.length();
                if (n > 0 && string2.charAt(n - 1) == '\u0000') {
                    string2 = string2.substring(0, n - 1);
                }
                if (string2.length() > 0) {
                    URI uRI = new URI(string2);
                    if ("file".equals(uRI.getScheme())) {
                        File file = new File(uRI.getPath());
                        if (file.isDirectory()) {
                            if (!bl2) {
                                VFSBrowser.browseDirectory(view, file.getPath());
                                bl2 = true;
                            }
                        } else {
                            AwtRunnableQueue.INSTANCE.runAfterIoTasks(new DraggedURLLoader(jEditTextArea, uRI.getPath()));
                        }
                        bl = true;
                        continue;
                    }
                    Log.log(1, this, "I do not know how to handle this URI " + uRI + ", ignoring.");
                    continue;
                }
                if (i == stringArray.length - 1) continue;
                Log.log(1, this, "Odd: there is an empty line in the uri list which is not the last line.");
            }
            if (bl) {
                return true;
            }
        }
        return true;
    }

    private boolean importText(JComponent jComponent, Transferable transferable) throws Exception {
        Object[] objectArray;
        Object object;
        int n;
        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        string = string.trim();
        Log.log(1, this, "=> String \"" + string + '\"');
        JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
        if (dragSource == null) {
            n = 0;
            object = string.split("\n");
            objectArray = object;
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                String string2 = objectArray[i];
                Object object2 = VFSManager.getVFSForPath(string2);
                if (!(object2 instanceof FileVFS) || string.startsWith("file://")) {
                    if (string2.startsWith("file://")) {
                        string2 = string2.substring(7);
                    }
                    ThreadUtilities.runInBackground(new DraggedURLLoader(jEditTextArea, string2));
                }
                n = 1;
            }
            if (n != 0) {
                return true;
            }
        }
        if (dragSource != null && jEditTextArea.getBuffer() == dragSource.getBuffer()) {
            compoundEdit = true;
            jEditTextArea.getBuffer().beginCompoundEdit();
        }
        sameTextArea = jEditTextArea == dragSource;
        n = jEditTextArea.getCaretPosition();
        object = jEditTextArea.getSelectionAtOffset(n);
        if (object != null) {
            if (sameTextArea) {
                return false;
            }
            int n3 = object.start;
            jEditTextArea.setSelectedText((Selection)object, string);
            jEditTextArea.setSelection(new Selection.Range(n3, n3 + string.length()));
        } else if (sameTextArea) {
            insertPos = n;
            insertOffset = 0;
            for (Object object2 : objectArray = jEditTextArea.getSelection()) {
                if (((Selection)object2).end >= insertPos + insertOffset) continue;
                insertOffset -= ((Selection)object2).end - ((Selection)object2).start;
            }
        } else {
            jEditTextArea.getBuffer().insert(n, string);
            jEditTextArea.setSelection(new Selection.Range(n, n + string.length()));
        }
        jEditTextArea.scrollToCaret(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        Log.log(1, this, "Export done");
        JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
        try {
            if (n == 0) {
                Log.log(1, this, "Export impossible");
                return;
            }
            if (transferable == null) {
                Log.log(1, this, "=> Null transferrable");
                jEditTextArea.selectNone();
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                Log.log(1, this, "=> String");
                if (sameTextArea) {
                    if (n == 2) {
                        jEditTextArea.setSelectedText(null, false);
                        insertPos += insertOffset;
                    }
                    try {
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        jEditTextArea.getBuffer().insert(insertPos, string);
                        jEditTextArea.setSelection(new Selection.Range(insertPos, insertPos + string.length()));
                    }
                    catch (Exception exception) {
                        Log.log(1, this, "exportDone in sameTextArea");
                        Log.log(1, this, exception);
                    }
                } else if (n == 2) {
                    jEditTextArea.setSelectedText(null, false);
                } else {
                    jEditTextArea.selectNone();
                }
            }
        }
        finally {
            if (compoundEdit) {
                compoundEdit = false;
                jEditTextArea.getBuffer().endCompoundEdit();
            }
        }
        dragSource = null;
    }

    private boolean isUriList(DataFlavor dataFlavor) {
        return "text".equals(dataFlavor.getPrimaryType()) && "uri-list".equals(dataFlavor.getSubType()) && dataFlavor.getRepresentationClass() == String.class;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (dragSource != null) {
            return true;
        }
        transferSupport.setDropAction(1);
        return super.canImport(transferSupport);
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
        boolean bl = false;
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (dataFlavor.equals(DataFlavor.javaFileListFlavor) || this.isUriList(dataFlavor)) {
                bl = true;
                break;
            }
            if (!dataFlavor.equals(DataFlavor.stringFlavor) || !jEditTextArea.isEditable()) continue;
            bl = true;
            break;
        }
        Log.log(1, this, "canImport() returning " + bl);
        return bl;
    }

    private static class DraggedURLLoader
    extends IoTask {
        private final JEditTextArea textArea;
        private final String url;

        DraggedURLLoader(JEditTextArea jEditTextArea, String string) {
            this.textArea = jEditTextArea;
            this.url = string;
        }

        @Override
        public void _run() {
            EditPane editPane = EditPane.get(this.textArea);
            jEdit.openFile(editPane, this.url);
        }
    }

    private static class TextAreaSelection
    extends StringSelection {
        final JEditTextArea textArea;

        TextAreaSelection(JEditTextArea jEditTextArea) {
            super(jEditTextArea.getSelectedText());
            this.textArea = jEditTextArea;
        }
    }
}

