/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.script.SV;

public class JSONWriter {
    protected OC oc;
    protected int indent = 0;
    private Map<String, String> modifiedKeys;
    private static final String SPACES = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t";

    public void setModifyKeys(Map<String, String> mapNewToOld) {
        this.modifiedKeys = mapNewToOld;
    }

    protected OC append(String s) {
        if (s != null) {
            this.oc.append(SPACES.substring(0, Math.min(this.indent, SPACES.length()))).append(s);
        }
        return this.oc;
    }

    public void setStream(OutputStream os) {
        this.oc = new OC().setParams(null, null, true, os);
    }

    public boolean closeStream() {
        this.oc.closeChannel();
        return true;
    }

    public void writeObject(Object o) {
        if (o == null) {
            this.writeNull();
        } else if (o instanceof Map) {
            this.writeMap((Map)o);
        } else if (o instanceof List) {
            this.writeList((List)o);
        } else if (o instanceof String) {
            this.writeString((String)o);
        } else if (o instanceof Boolean) {
            this.writeBoolean((Boolean)o);
        } else if (o instanceof Number) {
            this.writeNumber((Number)o);
        } else if (o.getClass().isArray()) {
            this.writeArray(o);
        } else if (o instanceof SV) {
            this.append(((SV)o).toJSON());
        } else {
            this.writeString(o.toString());
        }
    }

    public void writeNull() {
        this.oc.append("\"null\"");
    }

    public void writeNumber(Number o) {
        String s = o.toString();
        if (s.equals("NaN")) {
            this.writeString(s);
        } else {
            this.oc.append(s);
        }
    }

    public void writeBoolean(Boolean o) {
        this.oc.append(o.toString());
    }

    public void writeString(String str) {
        this.oc.append(PT.esc(str));
    }

    public void writeString(String str, SB sbSym) {
        sbSym.append(PT.esc(str));
    }

    public void writeMap(Map<String, Object> map) {
        if (map.isEmpty()) {
            this.append("{}");
            return;
        }
        this.mapOpen();
        String sep = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = this.getAndCheckValue(map, key);
            if (value == null) continue;
            this.oc.append(sep);
            this.mapAddKeyValue(key, value, null);
            sep = ",\n";
        }
        this.mapClose();
    }

    protected Object getAndCheckValue(Map<String, Object> map, String key) {
        return map.get(key);
    }

    public void mapOpen() {
        this.oc.append("{\n");
        ++this.indent;
    }

    public void mapClose() {
        --this.indent;
        this.oc.append("\n");
        this.append("}");
    }

    public void mapAddKey(String key) {
        this.append("");
        if (this.modifiedKeys != null && this.modifiedKeys.containsKey(key)) {
            key = this.modifiedKeys.get(key);
        }
        this.writeString(key);
        this.oc.append(":");
    }

    public void mapAddKeyValue(String key, Object value, String terminator) {
        this.mapAddKey(key);
        this.writeObject(value);
        if (terminator != null) {
            this.oc.append(terminator);
        }
    }

    public void mapAddKeyValueRaw(String key, Object value, String terminator) {
        this.mapAddKey(key);
        this.oc.append(value.toString());
        if (terminator != null) {
            this.oc.append(terminator);
        }
    }

    public void mapAddMapAllExcept(String key, Map<String, Object> map, String except) {
        this.mapAddKey(key);
        this.mapOpen();
        String sep = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key1 = entry.getKey();
            if (PT.isOneOf(key1, except)) continue;
            this.oc.append(sep);
            this.mapAddKeyValue(key1, entry.getValue(), null);
            sep = ",\n";
        }
        this.mapClose();
    }

    public void writeList(List<Object> list) {
        int n = list.size();
        this.arrayOpen(false);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.oc.append(",");
            }
            this.arrayAdd(list.get(i));
        }
        this.arrayClose(false);
    }

    public void writeArray(Object o) {
        this.arrayOpen(false);
        int n = Array.getLength(o);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.oc.append(",");
            }
            this.arrayAdd(Array.get(o, i));
        }
        this.arrayClose(false);
    }

    public void arrayOpen(boolean andIndent) {
        this.oc.append("[");
        if (andIndent) {
            ++this.indent;
        }
    }

    public void arrayAdd(Object o) {
        this.writeObject(o instanceof Float && ((Float)o).isNaN() || o instanceof Double && ((Double)o).isNaN() ? "NaN" : o);
    }

    public void arrayClose(boolean andIndent) {
        if (andIndent) {
            --this.indent;
            this.append("");
        }
        this.oc.append("]");
    }
}

