/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;

class JaguarReader
extends VolumeFileReader {
    private float[] extents = new float[3];

    JaguarReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2VFR(sg, br);
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        String atomLine;
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("Jaguar data\n");
        this.jvxlFileHeaderBuffer.append("\n");
        while ((atomLine = this.rd()) != null && atomLine.indexOf("origin=") < 0) {
        }
        String[] tokens = PT.getTokensAt((String)atomLine, (int)0);
        if (tokens.length == 4 && tokens[0].equals("origin=")) {
            this.volumetricOrigin.set(this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[2]), this.parseFloatStr(tokens[3]));
            VolumeFileReader.checkAtomLine(this.isXLowToHigh, this.isAngstroms, "0", "0 " + tokens[1] + " " + tokens[2] + " " + tokens[3], this.jvxlFileHeaderBuffer);
            if (!this.isAngstroms) {
                this.volumetricOrigin.scale(0.5291772f);
            }
        }
        this.readExtents(0);
        this.readExtents(1);
        this.readExtents(2);
        tokens = PT.getTokens((String)this.rd());
        this.voxelCounts[0] = this.parseIntStr(tokens[1]);
        this.voxelCounts[1] = this.parseIntStr(tokens[2]);
        this.voxelCounts[2] = this.parseIntStr(tokens[3]);
        float factor = this.isAngstroms ? 1.0f : 0.5291772f;
        float d = this.extents[0] / (float)(this.voxelCounts[0] - 1);
        this.volumetricVectors[0].set(d * factor, 0.0f, 0.0f);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[0] + " " + d + " 0.0 0.0\n");
        d = this.extents[1] / (float)(this.voxelCounts[1] - 1);
        this.volumetricVectors[1].set(0.0f, d * factor, 0.0f);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[1] + " 0.0 " + d + " 0.0\n");
        d = this.extents[2] / (float)(this.voxelCounts[2] - 1);
        this.volumetricVectors[2].set(0.0f, 0.0f, d * factor);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[2] + " 0.0 0.0 " + d + "\n");
        this.rd();
    }

    private void readExtents(int voxelVectorIndex) throws Exception {
        String[] tokens = PT.getTokens((String)this.rd());
        this.extents[voxelVectorIndex] = this.parseFloatStr(tokens[voxelVectorIndex + 1]);
    }
}

