/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public final class DefaultAuthenticator
extends Authenticator {
    private static final DefaultAuthenticator INSTANCE = new DefaultAuthenticator();
    private final Collection<Pair<String, Authenticator.RequestorType>> failedCredentials = new HashSet<Pair<String, Authenticator.RequestorType>>();
    private boolean enabled = true;

    public static DefaultAuthenticator getInstance() {
        return INSTANCE;
    }

    private DefaultAuthenticator() {
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (OsmApi.isUsingOAuth() && Objects.equals(OsmApi.getOsmApi().getHost(), this.getRequestingHost()) && Authenticator.RequestorType.SERVER.equals((Object)this.getRequestorType())) {
                return null;
            }
            Pair<String, Authenticator.RequestorType> hostTypePair = Pair.create(this.getRequestingHost(), this.getRequestorType());
            boolean hasFailedPreviously = this.failedCredentials.contains(hostTypePair);
            CredentialsAgentResponse response = CredentialsManager.getInstance().getCredentials(this.getRequestorType(), this.getRequestingHost(), hasFailedPreviously);
            if (response == null || response.isCanceled()) {
                return null;
            }
            if (Authenticator.RequestorType.PROXY.equals((Object)this.getRequestorType())) {
                this.failedCredentials.add(hostTypePair);
            } else {
                this.failedCredentials.remove(hostTypePair);
            }
            return new PasswordAuthentication(response.getUsername(), response.getPassword());
        }
        catch (CredentialsAgentException e) {
            Logging.error(e);
            return null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean addFailedCredentialHost(String host) {
        return this.failedCredentials.add(Pair.create(host, Authenticator.RequestorType.SERVER));
    }

    public boolean removeFailedCredentialHost(String host) {
        return this.failedCredentials.remove(Pair.create(host, Authenticator.RequestorType.SERVER));
    }
}

