/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.i18n;

import java.util.HashSet;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.i18n.ReplacementTrie;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;

public abstract class I18n {
    protected OfficeReader ofr;
    protected LaTeXConfig config;
    protected ReplacementTrie stringReplace;
    protected boolean bGreekMath;
    protected boolean bAlwaysUseDefaultLang;
    protected String sDefaultCTLLanguage;
    protected String sDefaultCTLCountry;
    protected String sDefaultLanguage;
    protected String sDefaultCountry;
    protected HashSet<String> languages = new HashSet();

    public I18n(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        this.ofr = ofr;
        this.config = config;
        this.stringReplace = config.getStringReplace();
        this.bGreekMath = config.greekMath();
        boolean bl = this.bAlwaysUseDefaultLang = !config.multilingual();
        if (ofr != null) {
            if (config.multilingual()) {
                StyleWithProperties style = ofr.getDefaultParStyle();
                if (style != null) {
                    this.sDefaultLanguage = style.getProperty("fo:language");
                    this.sDefaultCountry = style.getProperty("fo:country");
                    this.sDefaultCTLLanguage = style.getProperty("style:language-complex");
                    this.sDefaultCTLCountry = style.getProperty("style:country-complex");
                }
            } else {
                this.sDefaultLanguage = ofr.getMajorityLanguage();
            }
        }
        if (this.sDefaultLanguage == null) {
            this.sDefaultLanguage = "en";
        }
    }

    public abstract void appendDeclarations(LaTeXDocumentPortion var1, LaTeXDocumentPortion var2);

    public abstract void applyLanguage(StyleWithProperties var1, boolean var2, boolean var3, BeforeAfter var4);

    public abstract void pushSpecialTable(String var1);

    public abstract void popSpecialTable();

    public abstract String convert(String var1, boolean var2, String var3);

    public String getDefaultLanguage() {
        return this.sDefaultLanguage;
    }

    public String getDefaultCountry() {
        return this.sDefaultCountry;
    }
}

