# Runs a {#match_set set of matches} to produce {#match_results results}.
class MetasploitDataModels::AutomaticExploitation::Run < ActiveRecord::Base
  #
  # Associations
  #

  # Results of each match in {#match_set}.
  has_many :match_results,
           class_name:'MetasploitDataModels::AutomaticExploitation::MatchResult',
           inverse_of: :run,
           dependent: :destroy

  # Set of matches to run
  belongs_to :match_set,
             class_name: 'MetasploitDataModels::AutomaticExploitation::MatchSet',
             inverse_of: :runs

  # User that initiated this run.
  belongs_to :user,
             class_name: "Mdm::User",
             inverse_of: :automatic_exploitation_runs

  # Workspace in which this run was performed.
  belongs_to :workspace,
             class_name: "Mdm::Workspace",
             inverse_of: :automatic_exploitation_runs

  Metasploit::Concern.run(self)
end