// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepLib_MakeWire_HeaderFile
#define _BRepLib_MakeWire_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <BRepLib_WireError.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Vertex.hxx>
#include <TopTools_MapOfShape.hxx>
#include <BRepLib_MakeShape.hxx>
class StdFail_NotDone;
class TopoDS_Edge;
class TopoDS_Wire;
class TopTools_ListOfShape;
class TopoDS_Vertex;


//! Provides methods to build wires.
//!
//! A wire may be built :
//!
//! * From a single edge.
//!
//! * From a wire and an edge.
//!
//! - A new wire  is created with the edges  of  the
//! wire + the edge.
//!
//! - If the edge is not connnected  to the wire the
//! flag NotDone   is set and  the  method Wire will
//! raise an error.
//!
//! - The connection may be :
//!
//! . Through an existing vertex. The edge is shared.
//!
//! . Through a geometric coincidence of vertices.
//! The edge is  copied  and the vertices from the
//! edge are  replaced  by  the vertices from  the
//! wire.
//!
//! . The new edge and the connection vertices are
//! kept by the algorithm.
//!
//! * From 2, 3, 4 edges.
//!
//! - A wire is  created from  the first edge, the
//! following edges are added.
//!
//! * From many edges.
//!
//! - The following syntax may be used :
//!
//! BRepLib_MakeWire MW;
//!
//! // for all the edges ...
//! MW.Add(anEdge);
//!
//! TopoDS_Wire W = MW;
class BRepLib_MakeWire  : public BRepLib_MakeShape
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! NotDone MakeWire.
  Standard_EXPORT BRepLib_MakeWire();
  
  //! Make a Wire from an edge.
  Standard_EXPORT BRepLib_MakeWire(const TopoDS_Edge& E);
  
  //! Make a Wire from two edges.
  Standard_EXPORT BRepLib_MakeWire(const TopoDS_Edge& E1, const TopoDS_Edge& E2);
  
  //! Make a Wire from three edges.
  Standard_EXPORT BRepLib_MakeWire(const TopoDS_Edge& E1, const TopoDS_Edge& E2, const TopoDS_Edge& E3);
  
  //! Make a Wire from four edges.
  Standard_EXPORT BRepLib_MakeWire(const TopoDS_Edge& E1, const TopoDS_Edge& E2, const TopoDS_Edge& E3, const TopoDS_Edge& E4);
  
  //! Make a Wire from a Wire. Usefull for adding later.
  Standard_EXPORT BRepLib_MakeWire(const TopoDS_Wire& W);
  
  //! Add an edge to a wire.
  Standard_EXPORT BRepLib_MakeWire(const TopoDS_Wire& W, const TopoDS_Edge& E);
  
  //! Add the edge <E> to the current wire.
  Standard_EXPORT   void Add (const TopoDS_Edge& E) ;
  
  //! Add the edges of <W> to the current wire.
  Standard_EXPORT   void Add (const TopoDS_Wire& W) ;
  
  //! Add the edges of <L> to the current wire.
  //! The edges are not to be consecutive.  But they are
  //! to be all connected geometrically or topologically.
  Standard_EXPORT   void Add (const TopTools_ListOfShape& L) ;
  
  Standard_EXPORT   BRepLib_WireError Error()  const;
  
  //! Returns the new wire.
  Standard_EXPORT  const  TopoDS_Wire& Wire()  const;
Standard_EXPORT operator TopoDS_Wire() const;
  
  //! Returns the last edge added to the wire.
  Standard_EXPORT  const  TopoDS_Edge& Edge()  const;
  
  //! Returns the last connecting vertex.
  Standard_EXPORT  const  TopoDS_Vertex& Vertex()  const;




protected:





private:



  BRepLib_WireError myError;
  TopoDS_Edge myEdge;
  TopoDS_Vertex myVertex;
  TopTools_MapOfShape myVertices;
  TopoDS_Vertex FirstVertex;
  TopoDS_Vertex VF;
  TopoDS_Vertex VL;


};







#endif // _BRepLib_MakeWire_HeaderFile
