// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ChFiDS_CommonPoint_HeaderFile
#define _ChFiDS_CommonPoint_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopoDS_Edge.hxx>
#include <TopoDS_Vertex.hxx>
#include <gp_Pnt.hxx>
#include <gp_Vec.hxx>
#include <Standard_Real.hxx>
#include <Standard_Boolean.hxx>
#include <TopAbs_Orientation.hxx>
class Standard_DomainError;
class Standard_TypeMismatch;
class TopoDS_Vertex;
class TopoDS_Edge;
class gp_Pnt;
class gp_Vec;


//! point    start/end of  fillet common  to  2 adjacent  filets
//! and  to an edge on  one of 2 faces participating
//! in  the construction of  the  fillet
class ChFiDS_CommonPoint 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Empty constructor.
  Standard_EXPORT ChFiDS_CommonPoint();
  
  //! default value for all fields
  Standard_EXPORT   void Reset() ;
  
  //! Sets the values of a point which is a vertex on
  //! the initial facet of restriction of one
  //! of the surface.
      void SetVertex (const TopoDS_Vertex& V) ;
  
  //! Sets the values of a point which is on the arc
  //! A, at parameter Param.
  Standard_EXPORT   void SetArc (const Standard_Real Tol, const TopoDS_Edge& A, const Standard_Real Param, const TopAbs_Orientation TArc) ;
  
  //! Sets the value of the parameter on the spine
  Standard_EXPORT   void SetParameter (const Standard_Real Param) ;
  
  //! Set the 3d point for a commonpoint that is not
  //! a vertex or on an arc.
      void SetPoint (const gp_Pnt& Point) ;
  
  //! Set the output 3d  vector
      void SetVector (const gp_Vec& Vector) ;
  
  //! This method set the fuzziness on the point.
      void SetTolerance (const Standard_Real Tol) ;
  
  //! This method returns the fuzziness on the point.
      Standard_Real Tolerance()  const;
  
  //! Returns TRUE if the point is a vertex on the initial
  //! restriction facet of the surface.
      Standard_Boolean IsVertex()  const;
  
  //! Returns the information about the point when it is
  //! on the domain of the first patch, i-e when the function
  //! IsVertex returns True.
  //! Otherwise, an exception is raised.
     const  TopoDS_Vertex& Vertex()  const;
  
  //! Returns TRUE if the point is a on an edge of the initial
  //! restriction facet of the surface.
      Standard_Boolean IsOnArc()  const;
  
  //! Returns the arc of restriction containing the
  //! vertex.
  Standard_EXPORT  const  TopoDS_Edge& Arc()  const;
  
  //! Returns the transition of the point on the arc
  //! returned by Arc().
  Standard_EXPORT   TopAbs_Orientation TransitionOnArc()  const;
  
  //! Returns the parameter of the point on the
  //! arc returned by the method Arc().
  Standard_EXPORT   Standard_Real ParameterOnArc()  const;
  
  //! Returns  the parameter the  paramter on the  spine
  Standard_EXPORT   Standard_Real Parameter()  const;
  
  //! Returns the 3d point
     const  gp_Pnt& Point()  const;
  
  //! Returns TRUE if the output vector is  stored.
      Standard_Boolean HasVector()  const;
  
  //! Returns the output  3d vector
     const  gp_Vec& Vector()  const;




protected:





private:



  TopoDS_Edge arc;
  TopoDS_Vertex vtx;
  gp_Pnt point;
  gp_Vec vector;
  Standard_Real tol;
  Standard_Real prmarc;
  Standard_Real prmtg;
  Standard_Boolean isonarc;
  TopAbs_Orientation traarc;
  Standard_Boolean isvtx;
  Standard_Boolean hasvector;


};


#include <ChFiDS_CommonPoint.lxx>





#endif // _ChFiDS_CommonPoint_HeaderFile
