/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVersionSetter;

public class Targeter {
    private final Configuration configuration;

    public Targeter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool) throws IOException {
        HashSet hashSet = this.configuration.warn != null ? null : new HashSet();
        classPool.classesAccept(new ClassVersionSetter(this.configuration.targetClassVersion, hashSet));
        if (hashSet != null && hashSet.size() > 0) {
            System.err.print("Warning: some classes have more recent versions (");
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                System.err.print(ClassUtil.externalClassVersion(n));
                if (!iterator.hasNext()) continue;
                System.err.print(",");
            }
            System.err.println(")");
            System.err.println("         than the target version (" + ClassUtil.externalClassVersion(this.configuration.targetClassVersion) + ").");
            if (!this.configuration.ignoreWarnings) {
                System.err.println("         If you are sure this is not a problem,");
                System.err.println("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
    }
}

