/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;

public class MethodImplementationTraveler
extends SimplifiedVisitor
implements MemberVisitor {
    private final boolean visitThisMethod;
    private final boolean visitSuperMethods;
    private final boolean visitInterfaceMethods;
    private final boolean visitOverridingMethods;
    private final MemberVisitor memberVisitor;

    public MethodImplementationTraveler(boolean bl, boolean bl2, boolean bl3, boolean bl4, MemberVisitor memberVisitor) {
        this.visitThisMethod = bl;
        this.visitSuperMethods = bl2;
        this.visitInterfaceMethods = bl3;
        this.visitOverridingMethods = bl4;
        this.memberVisitor = memberVisitor;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.visitThisMethod) {
            programMethod.accept(programClass, this.memberVisitor);
        }
        if (!this.isSpecial(programClass, programMethod)) {
            programClass.hierarchyAccept(false, this.visitSuperMethods, this.visitInterfaceMethods, this.visitOverridingMethods, new NamedMethodVisitor(programMethod.getName(programClass), programMethod.getDescriptor(programClass), new MemberAccessFilter(0, 10, this.memberVisitor)));
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.visitThisMethod) {
            libraryMethod.accept(libraryClass, this.memberVisitor);
        }
        if (!this.isSpecial(libraryClass, libraryMethod)) {
            libraryClass.hierarchyAccept(false, this.visitSuperMethods, this.visitInterfaceMethods, this.visitOverridingMethods, new NamedMethodVisitor(libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass), new MemberAccessFilter(0, 10, this.memberVisitor)));
        }
    }

    private boolean isSpecial(Clazz clazz, Method method) {
        return (method.getAccessFlags() & 0xA) != 0 || method.getName(clazz).equals("<init>");
    }
}

