/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredObjectPropertyAxiomGenerator;

public class InferredObjectPropertyCharacteristicAxiomGenerator
extends InferredObjectPropertyAxiomGenerator<OWLObjectPropertyCharacteristicAxiom> {
    @Override
    protected void addAxioms(OWLObjectProperty entity, OWLReasoner reasoner, @Nonnull OWLDataFactory dataFactory, Set<OWLObjectPropertyCharacteristicAxiom> result) {
        InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(dataFactory.getOWLFunctionalObjectPropertyAxiom(entity), reasoner, result);
        InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(entity), reasoner, result);
        InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(dataFactory.getOWLSymmetricObjectPropertyAxiom(entity), reasoner, result);
        InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(dataFactory.getOWLAsymmetricObjectPropertyAxiom(entity), reasoner, result);
        InferredObjectPropertyCharacteristicAxiomGenerator.addTransitiveAxiomIfEntailed(entity, reasoner, dataFactory, result);
        InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(dataFactory.getOWLReflexiveObjectPropertyAxiom(entity), reasoner, result);
        InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(dataFactory.getOWLIrreflexiveObjectPropertyAxiom(entity), reasoner, result);
    }

    protected static void addTransitiveAxiomIfEntailed(@Nonnull OWLObjectProperty property, OWLReasoner reasoner, OWLDataFactory dataFactory, Set<OWLObjectPropertyCharacteristicAxiom> result) {
        OWLTransitiveObjectPropertyAxiom axiom = dataFactory.getOWLTransitiveObjectPropertyAxiom(property);
        if (reasoner.isEntailmentCheckingSupported(axiom.getAxiomType()) && reasoner.isEntailed(axiom) && !InferredObjectPropertyCharacteristicAxiomGenerator.triviallyTransitiveCheck(property, reasoner, dataFactory)) {
            result.add(axiom);
        }
    }

    private static boolean triviallyTransitiveCheck(@Nonnull OWLObjectProperty property, OWLReasoner reasoner, OWLDataFactory df) {
        OWLObjectSomeValuesFrom chain = df.getOWLObjectSomeValuesFrom(property, df.getOWLObjectSomeValuesFrom(property, df.getOWLThing()));
        return !reasoner.isSatisfiable(chain);
    }

    protected static void addIfEntailed(OWLObjectPropertyCharacteristicAxiom axiom, OWLReasoner reasoner, Set<OWLObjectPropertyCharacteristicAxiom> result) {
        if (reasoner.isEntailmentCheckingSupported(axiom.getAxiomType()) && reasoner.isEntailed(axiom)) {
            result.add(axiom);
        }
    }

    @Override
    public String getLabel() {
        return "Object property characteristics";
    }
}

