/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.error;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.protege.editor.core.ui.error.ErrorLogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLog {
    private final Logger logger = LoggerFactory.getLogger(ErrorLog.class);

    @Deprecated
    public void addListener(ErrorLogListener listener) {
        this.logger.error("The listener {} has not been added.  The addListener method is deprecated.", (Object)listener.getClass().getName());
    }

    @Deprecated
    public void removeListener(ErrorLogListener listener) {
        this.logger.error("The listener {} has not been removed.  The removeListener method is deprecated.", (Object)listener.getClass().getName());
    }

    @Deprecated
    public void clearListeners() {
        this.logger.warn("Clear listeners");
    }

    @Deprecated
    public void uncaughtException(Thread t, Throwable e) {
        this.logError(e);
    }

    @Deprecated
    public void logError(Throwable throwable) {
        this.logger.error("An error was thrown: {}", (Object)throwable.getMessage(), (Object)throwable);
    }

    @Deprecated
    public List<ErrorLogEntry> getEntries() {
        return Collections.emptyList();
    }

    @Deprecated
    public void clear() {
    }

    @Deprecated
    public void handleError(Thread t, Throwable e) {
        this.logError(e);
    }

    public static class ErrorLogEntry {
        private final int id;
        private final long timeStamp;
        private final Throwable throwable;

        public ErrorLogEntry(int id, long timeStamp, Throwable throwable) {
            this.id = id;
            this.timeStamp = timeStamp;
            this.throwable = throwable;
        }

        public int getId() {
            return this.id;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Error ");
            sb.append(this.id);
            sb.append(" Logged at ");
            sb.append(new Date(this.timeStamp));
            sb.append("\n");
            sb.append(this.throwable.getClass().getSimpleName());
            sb.append(": ");
            sb.append(this.throwable.getMessage());
            sb.append("\n");
            for (StackTraceElement element : this.throwable.getStackTrace()) {
                sb.append("    ");
                sb.append(element.toString());
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

