/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.wizard.page;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.wizard.AbstractWizardPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.LoadedOntologyPage;

public class ImportTypePage
extends AbstractWizardPanel {
    public static final String ID = "ImportTypePage";
    private JRadioButton webRadioButton;
    private JRadioButton localFileRadioButton;
    private JRadioButton libraryRadioButton;
    private JRadioButton loadedOntologyButton;

    public ImportTypePage(OWLEditorKit owlEditorKit) {
        super((Object)ID, "Import type", (EditorKit)owlEditorKit);
    }

    protected void createUI(JComponent parent) {
        this.setInstructions("Please choose an option:");
        parent.setLayout(new BorderLayout());
        Box box = new Box(1);
        this.localFileRadioButton = new JRadioButton("Import an ontology contained in a specific file.");
        box.add(this.localFileRadioButton);
        this.webRadioButton = new JRadioButton("Import an ontology contained in a document located on the web.");
        box.add(this.webRadioButton);
        this.loadedOntologyButton = new JRadioButton("Import an ontology that is already loaded in the workspace.");
        box.add(this.loadedOntologyButton);
        this.libraryRadioButton = new JRadioButton("Import an ontology that is contained in one of the ontology libraries.");
        box.add(this.libraryRadioButton);
        parent.add((Component)box, "North");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.webRadioButton);
        bg.add(this.localFileRadioButton);
        bg.add(this.libraryRadioButton);
        bg.add(this.loadedOntologyButton);
        this.localFileRadioButton.setSelected(true);
    }

    public Object getNextPanelDescriptor() {
        if (this.webRadioButton.isSelected()) {
            return "URLPage";
        }
        if (this.localFileRadioButton.isSelected()) {
            return "LocalFilePage";
        }
        if (this.libraryRadioButton.isSelected()) {
            return "LibraryPage";
        }
        return LoadedOntologyPage.ID;
    }

    public Object getBackPanelDescriptor() {
        return super.getBackPanelDescriptor();
    }
}

