/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import git4idea.config.GitVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableDetector {
    private static final Logger LOG = Logger.getInstance(GitExecutableDetector.class);
    private static final String[] UNIX_PATHS = new String[]{"/usr/local/bin", "/usr/bin", "/opt/local/bin", "/opt/bin", "/usr/local/git/bin"};
    private static final String UNIX_EXECUTABLE = "git";
    private static final File WIN_ROOT = new File("C:");
    private static final String GIT_CMD = "git.cmd";
    private static final String GIT_EXE = "git.exe";
    public static final String DEFAULT_WIN_GIT = "git.exe";
    public static final String PATH_ENV = "PATH";

    @NotNull
    public String detect() {
        if (SystemInfo.isWindows) {
            String string = this.detectForWindows();
            if (string == null) {
                GitExecutableDetector.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = GitExecutableDetector.detectForUnix();
        if (string == null) {
            GitExecutableDetector.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String detectForUnix() {
        for (String p : UNIX_PATHS) {
            File f = new File(p, UNIX_EXECUTABLE);
            if (!f.exists()) continue;
            String string = f.getPath();
            if (string == null) {
                GitExecutableDetector.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (UNIX_EXECUTABLE == null) {
            GitExecutableDetector.$$$reportNull$$$0(3);
        }
        return UNIX_EXECUTABLE;
    }

    @NotNull
    private String detectForWindows() {
        String exec = this.checkInPath();
        if (exec != null) {
            String string = exec;
            if (string == null) {
                GitExecutableDetector.$$$reportNull$$$0(4);
            }
            return string;
        }
        exec = GitExecutableDetector.checkProgramFiles();
        if (exec != null) {
            String string = exec;
            if (string == null) {
                GitExecutableDetector.$$$reportNull$$$0(5);
            }
            return string;
        }
        exec = GitExecutableDetector.checkCygwin();
        if (exec != null) {
            String string = exec;
            if (string == null) {
                GitExecutableDetector.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.checkSoleExecutable();
        if (string == null) {
            GitExecutableDetector.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private String checkInPath() {
        String PATH = this.getPath();
        if (PATH == null) {
            return null;
        }
        List pathEntries = StringUtil.split((String)PATH, (String)";");
        for (String pathEntry : pathEntries) {
            if (!GitExecutableDetector.looksLikeGit(pathEntry)) continue;
            return GitExecutableDetector.checkBinDir(new File(pathEntry));
        }
        return null;
    }

    private static boolean looksLikeGit(@NotNull String path) {
        if (path == null) {
            GitExecutableDetector.$$$reportNull$$$0(8);
        }
        List dirs = FileUtil.splitPath((String)path);
        for (String dir : dirs) {
            if (!dir.toLowerCase().startsWith(UNIX_EXECUTABLE)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String checkProgramFiles() {
        String[] PROGRAM_FILES = new String[]{"Program Files", "Program Files (x86)"};
        ArrayList<File> distrs = new ArrayList<File>();
        for (String programFiles : PROGRAM_FILES) {
            File pf = new File(WIN_ROOT, programFiles);
            File[] children = pf.listFiles(pathname -> pathname.isDirectory() && pathname.getName().toLowerCase().startsWith(UNIX_EXECUTABLE));
            if (!pf.exists() || children == null) continue;
            distrs.addAll(Arrays.asList(children));
        }
        Collections.sort(distrs, Collections.reverseOrder(new VersionDirsComparator()));
        for (File distr : distrs) {
            String exec = GitExecutableDetector.checkDistributive(distr);
            if (exec == null) continue;
            return exec;
        }
        return null;
    }

    @Nullable
    private static String checkCygwin() {
        String[] OTHER_WINDOWS_PATHS;
        for (String otherPath : OTHER_WINDOWS_PATHS = new String[]{FileUtil.toSystemDependentName((String)"cygwin/bin/git.exe")}) {
            File file = new File(WIN_ROOT, otherPath);
            if (!file.exists()) continue;
            return file.getPath();
        }
        return null;
    }

    @NotNull
    private String checkSoleExecutable() {
        if (this.runs(GIT_CMD)) {
            if (GIT_CMD == null) {
                GitExecutableDetector.$$$reportNull$$$0(9);
            }
            return GIT_CMD;
        }
        if ("git.exe" == null) {
            GitExecutableDetector.$$$reportNull$$$0(10);
        }
        return "git.exe";
    }

    @Nullable
    private static String checkDistributive(@Nullable File gitDir) {
        String[] binDirs;
        if (gitDir == null || !gitDir.exists()) {
            return null;
        }
        for (String binDir : binDirs = new String[]{"cmd", "bin"}) {
            String exec = GitExecutableDetector.checkBinDir(new File(gitDir, binDir));
            if (exec == null) continue;
            return exec;
        }
        return null;
    }

    @Nullable
    private static String checkBinDir(@NotNull File binDir) {
        if (binDir == null) {
            GitExecutableDetector.$$$reportNull$$$0(11);
        }
        if (!binDir.exists()) {
            return null;
        }
        for (String exec : new String[]{GIT_CMD, "git.exe"}) {
            File fe = new File(binDir, exec);
            if (!fe.exists()) continue;
            return fe.getPath();
        }
        return null;
    }

    protected boolean runs(@NotNull String exec) {
        if (exec == null) {
            GitExecutableDetector.$$$reportNull$$$0(12);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(exec);
        commandLine.setCharset(CharsetToolkit.getDefaultSystemCharset());
        try {
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput result2 = handler.runProcess((int)TimeUnit.SECONDS.toMillis(5L));
            return !result2.isTimeout();
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @Nullable
    protected String getPath() {
        return System.getenv(PATH_ENV);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableDetector";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "detectForUnix";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "detectForWindows";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableDetector";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "checkSoleExecutable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeGit";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkBinDir";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VersionDirsComparator
    implements Comparator<File> {
        private VersionDirsComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String name1 = f1.getName().toLowerCase();
            String name2 = f2.getName().toLowerCase();
            if (name1.equals(GitExecutableDetector.UNIX_EXECUTABLE)) {
                return name2.equals(GitExecutableDetector.UNIX_EXECUTABLE) ? VersionDirsComparator.fallback(f1, f2) : 1;
            }
            if (name2.equals(GitExecutableDetector.UNIX_EXECUTABLE)) {
                return -1;
            }
            Pattern GIT_WITH_VERSION = Pattern.compile("^git[ _]*([\\d\\.]*).*$");
            Matcher m1 = GIT_WITH_VERSION.matcher(name1);
            Matcher m2 = GIT_WITH_VERSION.matcher(name2);
            if (m1.matches() && m2.matches()) {
                GitVersion v1 = VersionDirsComparator.parseGitVersion(m1.group(1));
                GitVersion v2 = VersionDirsComparator.parseGitVersion(m2.group(1));
                if (v1 == null || v2 == null) {
                    return VersionDirsComparator.fallback(f1, f2);
                }
                int compareVersions = v1.compareTo(v2);
                return compareVersions == 0 ? VersionDirsComparator.fallback(f1, f2) : compareVersions;
            }
            return VersionDirsComparator.fallback(f1, f2);
        }

        private static int fallback(@NotNull File f1, @NotNull File f2) {
            int compareParents;
            if (f1 == null) {
                VersionDirsComparator.$$$reportNull$$$0(0);
            }
            if (f2 == null) {
                VersionDirsComparator.$$$reportNull$$$0(1);
            }
            if ((compareParents = f1.getParentFile().getName().compareTo(f2.getParentFile().getName())) != 0) {
                return -compareParents;
            }
            String name1 = f1.getName().toLowerCase();
            String name2 = f2.getName().toLowerCase();
            return name1.compareTo(name2);
        }

        @Nullable
        private static GitVersion parseGitVersion(@Nullable String name) {
            if (name == null) {
                return null;
            }
            Pattern VERSION = Pattern.compile("(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?.*");
            Matcher m = VERSION.matcher(name);
            if (!m.matches()) {
                return null;
            }
            try {
                int major = Integer.parseInt(m.group(1));
                return new GitVersion(major, VersionDirsComparator.parseOrNull(m.group(2)), VersionDirsComparator.parseOrNull(m.group(3)), VersionDirsComparator.parseOrNull(m.group(4)));
            }
            catch (NumberFormatException e) {
                LOG.info("Unexpected NFE when parsing [" + name + "]", (Throwable)e);
                return null;
            }
        }

        private static int parseOrNull(String group) {
            return group == null ? 0 : Integer.parseInt(group);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "f1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "f2";
                    break;
                }
            }
            objectArray[1] = "git4idea/config/GitExecutableDetector$VersionDirsComparator";
            objectArray[2] = "fallback";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

