/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import git4idea.commands.GitLineHandlerAdapter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitRebaseLineListener
extends GitLineHandlerAdapter {
    private static final Pattern PROGRESS = Pattern.compile("^Rebasing \\((\\d+)/(\\d+)\\)$");
    private Status myStatus;
    private String myProgressLine;

    @Override
    public synchronized void onLineAvailable(String line, Key outputType) {
        if (outputType == ProcessOutputTypes.STDOUT) {
            if (PROGRESS.matcher(line).matches()) {
                this.myProgressLine = line;
                this.myStatus = null;
            }
        } else if (line.startsWith("You can amend the commit now")) {
            assert (this.myStatus == null);
            this.myStatus = Status.EDIT;
        } else if (line.startsWith("Successfully rebased and updated")) {
            assert (this.myStatus == null);
            this.myStatus = Status.FINISHED;
        } else if (line.startsWith("Automatic cherry-pick failed") || line.startsWith("When you have resolved this problem")) {
            assert (this.myStatus == null || this.myStatus == Status.ERROR);
            this.myStatus = Status.CONFLICT;
        } else if (line.startsWith("Could not execute editor")) {
            assert (this.myStatus == null);
            this.myStatus = this.myProgressLine == null ? Status.CANCELLED : Status.ERROR;
        } else if ((line.startsWith("fatal") || line.startsWith("error: ") || line.startsWith("Cannot")) && this.myStatus != Status.CONFLICT) {
            this.myStatus = Status.ERROR;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Result getResult() {
        int total;
        int current;
        if (this.myProgressLine != null) {
            Matcher matcher = PROGRESS.matcher(this.myProgressLine);
            if (!matcher.matches()) throw new IllegalStateException("The wrong current result line: " + this.myProgressLine);
            current = Integer.parseInt(matcher.group(1));
            total = Integer.parseInt(matcher.group(2));
            return new Result(this.myStatus == null ? Status.FINISHED : this.myStatus, total, current);
        } else {
            current = 0;
            total = 0;
        }
        return new Result(this.myStatus == null ? Status.FINISHED : this.myStatus, total, current);
    }

    public static enum Status {
        CANCELLED,
        FINISHED,
        EDIT,
        CONFLICT,
        ERROR;

    }

    public static final class Result {
        public final Status status;
        public final int total;
        public final int current;

        public Result(Status status, int total, int current) {
            this.status = status;
            this.total = total;
            this.current = current;
        }
    }
}

