/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import org.apache.batik.gvt.CompositeGraphicsNode;

public class CanvasGraphicsNode
extends CompositeGraphicsNode {
    protected AffineTransform positionTransform;
    protected AffineTransform viewingTransform;
    protected Paint backgroundPaint;

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setPositionTransform(AffineTransform affineTransform) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.positionTransform = affineTransform;
        if (this.positionTransform != null) {
            this.transform = new AffineTransform(this.positionTransform);
            if (this.viewingTransform != null) {
                this.transform.concatenate(this.viewingTransform);
            }
        } else {
            this.transform = this.viewingTransform != null ? new AffineTransform(this.viewingTransform) : new AffineTransform();
        }
        if (this.transform.getDeterminant() != 0.0) {
            try {
                this.inverseTransform = this.transform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Error(noninvertibleTransformException.getMessage());
            }
        } else {
            this.inverseTransform = this.transform;
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    public AffineTransform getPositionTransform() {
        return this.positionTransform;
    }

    public void setViewingTransform(AffineTransform affineTransform) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.viewingTransform = affineTransform;
        if (this.positionTransform != null) {
            this.transform = new AffineTransform(this.positionTransform);
            if (this.viewingTransform != null) {
                this.transform.concatenate(this.viewingTransform);
            }
        } else {
            this.transform = this.viewingTransform != null ? new AffineTransform(this.viewingTransform) : new AffineTransform();
        }
        if (this.transform.getDeterminant() != 0.0) {
            try {
                this.inverseTransform = this.transform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Error(noninvertibleTransformException.getMessage());
            }
        } else {
            this.inverseTransform = this.transform;
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    public AffineTransform getViewingTransform() {
        return this.viewingTransform;
    }

    @Override
    public void primitivePaint(Graphics2D graphics2D) {
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(graphics2D.getClip());
        }
        super.primitivePaint(graphics2D);
    }
}

