/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.pserver;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorkerImpl;
import com.intellij.cvsSupport2.connections.pserver.PServerCvsSettings;
import com.intellij.cvsSupport2.connections.pserver.PServerLoginProvider;
import com.intellij.cvsSupport2.connections.ssh.SolveableAuthenticationException;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.cvsSupport2.javacvsImpl.io.StreamLogger;
import com.intellij.cvsSupport2.util.CvsFileUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.connection.PServerPasswordScrambler;
import org.netbeans.lib.cvsclient.connection.UnknownUserException;
import org.netbeans.lib.cvsclient.io.IStreamLogger;

public class PServerLoginProviderImpl
extends PServerLoginProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.connections.pserver.PServerLoginProviderImpl");

    @Override
    @Nullable
    public String getScrambledPasswordForCvsRoot(String cvsRoot) {
        return PServerLoginProviderImpl.getPassword(cvsRoot);
    }

    @Nullable
    private static String requestForPassword(String cvsRoot) {
        String password = Messages.showPasswordDialog((String)CvsBundle.message((String)"prompt.text.enter.password.for.cvs.root", (Object[])new Object[]{cvsRoot}), (String)CvsBundle.message((String)"prompt.title.enter.password.for.cvs.root", (Object[])new Object[0]));
        return password != null ? PServerPasswordScrambler.getInstance().scramble(password) : null;
    }

    @Override
    public CvsLoginWorker getLoginWorker(Project project, PServerCvsSettings pServerCvsSettings) {
        return new PServerLoginWorker(project, pServerCvsSettings);
    }

    private static void removeAllPasswordsForThisCvsRootFromPasswordFile(String cvsRoot) throws IOException {
        File passFile = PServerLoginProviderImpl.getPassFile();
        if (!passFile.isFile()) {
            return;
        }
        List<String> lines = CvsFileUtil.readLinesFrom(passFile, cvsRoot);
        try {
            CvsFileUtil.storeLines(lines, passFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void storePassword(String stringConfiguration, String scrambledPassword) throws IOException {
        File passFile = PServerLoginProviderImpl.getPassFile();
        FileUtil.createIfDoesntExist((File)passFile);
        List<String> lines = CvsFileUtil.readLinesFrom(passFile);
        lines.add(stringConfiguration + " " + scrambledPassword);
        CvsFileUtil.storeLines(lines, passFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getPassword(String config) {
        String string;
        File passFile = PServerLoginProviderImpl.getPassFile();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(passFile), CvsApplicationLevelConfiguration.getCharset()));
        try {
            string = PServerLoginProviderImpl.findPasswordIn(reader, config);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        reader.close();
        return string;
    }

    private static File getPassFile() {
        return CvsApplicationLevelConfiguration.getInstance().getPassFile();
    }

    @Nullable
    private static String findPasswordIn(BufferedReader reader, String config) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            String result;
            int position = line.indexOf(config);
            if (position == -1 || (result = line.substring(position + config.length())).isEmpty()) continue;
            return result.substring(1);
        }
        return null;
    }

    private static class PServerLoginWorker
    extends CvsLoginWorkerImpl<PServerCvsSettings> {
        private PServerLoginWorker(Project project, PServerCvsSettings settings) {
            super(project, settings);
        }

        @Override
        protected void silentLoginImpl(boolean forceCheck) throws AuthenticationException {
            String cvsRoot = ((PServerCvsSettings)this.mySettings).getCvsRootAsString();
            String stored = PServerLoginProviderImpl.getPassword(cvsRoot);
            if (stored == null) {
                throw new SolveableAuthenticationException(null);
            }
            if (forceCheck) {
                this.tryConnection();
            }
        }

        private void tryConnection() throws AuthenticationException {
            IConnection connection = ((PServerCvsSettings)this.mySettings).createConnection(new ReadWriteStatistics());
            try {
                connection.open((IStreamLogger)new StreamLogger());
                ((PServerCvsSettings)this.mySettings).setOffline(false);
            }
            catch (UnknownUserException e) {
                throw new SolveableAuthenticationException(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }

        public boolean promptForPassword() {
            String cvsRoot = ((PServerCvsSettings)this.mySettings).getCvsRootAsString();
            String password = PServerLoginProviderImpl.requestForPassword(cvsRoot);
            if (password == null) {
                return false;
            }
            try {
                PServerLoginProviderImpl.removeAllPasswordsForThisCvsRootFromPasswordFile(cvsRoot);
                PServerLoginProviderImpl.storePassword(cvsRoot, password);
            }
            catch (IOException e) {
                PServerLoginWorker.showConnectionErrorMessage(this.myProject, CvsBundle.message((String)"error.message.cannot.store.password", (Object[])new Object[]{e.getLocalizedMessage()}));
                return false;
            }
            ((PServerCvsSettings)this.mySettings).storePassword(password);
            return true;
        }

        @Override
        protected void clearOldCredentials() {
            ((PServerCvsSettings)this.mySettings).releasePassword();
        }
    }
}

