/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsCheckOut;

import com.intellij.util.containers.SLRUCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.CvsRoot;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.admin.AdminWriter;
import org.netbeans.lib.cvsclient.admin.EntriesHandler;
import org.netbeans.lib.cvsclient.admin.EntriesWriter;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.IAdminWriter;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.file.IFileReadOnlyHandler;
import org.netbeans.lib.cvsclient.file.IReaderFactory;

public class CheckoutAdminWriter
implements IAdminWriter {
    private final AdminWriter myDelegate;
    private final CheckoutEntriesWriter myEntriesCreator;

    public CheckoutAdminWriter(String lineSeparator, String charset) {
        this.myEntriesCreator = new CheckoutEntriesWriter(charset, lineSeparator);
        this.myDelegate = new AdminWriter(lineSeparator, charset, (EntriesWriter)this.myEntriesCreator);
    }

    public void ensureCvsDirectory(DirectoryObject directoryObject, String repositoryPath, CvsRoot cvsRoot, ICvsFileSystem cvsFileSystem) throws IOException {
        this.myDelegate.ensureCvsDirectory(directoryObject, repositoryPath, cvsRoot, cvsFileSystem);
    }

    public void setEntry(DirectoryObject directoryObject, Entry entry, ICvsFileSystem cvsFileSystem) throws IOException {
        this.myDelegate.setEntry(directoryObject, entry, cvsFileSystem);
    }

    public void removeEntryForFile(AbstractFileObject fileObject, ICvsFileSystem cvsFileSystem) throws IOException {
        this.myDelegate.removeEntryForFile(fileObject, cvsFileSystem);
    }

    public void pruneDirectory(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        this.myDelegate.pruneDirectory(directoryObject, cvsFileSystem);
    }

    public void editFile(FileObject fileObject, Entry entry, ICvsFileSystem cvsFileSystem, IFileReadOnlyHandler fileReadOnlyHandler) throws IOException {
        this.myDelegate.editFile(fileObject, entry, cvsFileSystem, fileReadOnlyHandler);
    }

    public void uneditFile(FileObject fileObject, ICvsFileSystem cvsFileSystem, IFileReadOnlyHandler fileReadOnlyHandler) throws IOException {
        this.myDelegate.uneditFile(fileObject, cvsFileSystem, fileReadOnlyHandler);
    }

    public void setStickyTagForDirectory(DirectoryObject directoryObject, String tag, ICvsFileSystem cvsFileSystem) throws IOException {
        this.myDelegate.setStickyTagForDirectory(directoryObject, tag, cvsFileSystem);
    }

    public void setEntriesDotStatic(DirectoryObject directoryObject, boolean set, ICvsFileSystem cvsFileSystem) throws IOException {
        this.myDelegate.setEntriesDotStatic(directoryObject, set, cvsFileSystem);
    }

    public void writeTemplateFile(DirectoryObject directoryObject, int fileLength, InputStream inputStream, IReaderFactory readerFactory, IClientEnvironment clientEnvironment) throws IOException {
        this.myDelegate.writeTemplateFile(directoryObject, fileLength, inputStream, readerFactory, clientEnvironment);
    }

    public void directoryAdded(DirectoryObject directory, ICvsFileSystem cvsFileSystem) throws IOException {
        this.myDelegate.directoryAdded(directory, cvsFileSystem);
    }

    public void finish() throws IOCommandException {
        this.myEntriesCreator.finish();
    }

    private static class MyWrappedIOException
    extends RuntimeException {
        private final IOException myInner;

        private MyWrappedIOException(IOException inner) {
            this.myInner = inner;
        }

        public IOException getInner() {
            return this.myInner;
        }
    }

    private static class MyCache
    extends SLRUCache<String, EntriesHandler> {
        private final String myCharset;
        private final String myLineSeparator;

        private MyCache(String charset, String lineSeparator) {
            super(1600, 224);
            this.myCharset = charset;
            this.myLineSeparator = lineSeparator;
        }

        @NotNull
        public EntriesHandler createValue(String key) {
            EntriesHandler entriesHandler;
            try {
                EntriesHandler result = new EntriesHandler(new File(key));
                result.read(this.myCharset);
                entriesHandler = result;
            }
            catch (IOException e) {
                throw new MyWrappedIOException(e);
            }
            if (entriesHandler == null) {
                MyCache.$$$reportNull$$$0(0);
            }
            return entriesHandler;
        }

        protected void onDropFromCache(String key, EntriesHandler value) {
            this.writeHandler(value);
        }

        private void writeHandler(EntriesHandler value) {
            try {
                value.write(this.myLineSeparator, this.myCharset);
            }
            catch (IOException e) {
                throw new MyWrappedIOException(e);
            }
        }

        public void finish() throws IOCommandException {
            Set entries = this.entrySet();
            try {
                for (Map.Entry entry : entries) {
                    ((EntriesHandler)entry.getValue()).write(this.myLineSeparator, this.myCharset);
                }
            }
            catch (IOException e) {
                throw new IOCommandException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/cvsoperations/cvsCheckOut/CheckoutAdminWriter$MyCache", "createValue"));
        }
    }

    private static class CheckoutEntriesWriter
    implements EntriesWriter {
        private final MyCache myCache;

        private CheckoutEntriesWriter(String charset, String lineSeparator) {
            this.myCache = new MyCache(charset, lineSeparator);
        }

        public void addEntry(File directory, Entry entry) throws IOException {
            try {
                EntriesHandler handler = (EntriesHandler)this.myCache.get(directory.getAbsolutePath());
                handler.getEntries().addEntry(entry);
            }
            catch (MyWrappedIOException e) {
                throw e.getInner();
            }
        }

        public void finish() throws IOCommandException {
            this.myCache.finish();
        }
    }
}

