/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.mantis;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.mantis.MantisRepository;
import com.intellij.tasks.mantis.model.IssueData;
import com.intellij.tasks.mantis.model.IssueHeaderData;
import com.intellij.tasks.mantis.model.IssueNoteData;
import com.intellij.util.containers.ContainerUtil;
import icons.TasksCoreIcons;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MantisTask
extends Task {
    private final String myId;
    private final String mySummary;
    private final String myDescription;
    private final Date myUpdated;
    private final Date myCreated;
    private final boolean myClosed;
    private String myProjectName;
    private MantisRepository myRepository;
    private final Comment[] myComments;

    public MantisTask(@NotNull IssueData data, @NotNull MantisRepository repository) {
        if (data == null) {
            MantisTask.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            MantisTask.$$$reportNull$$$0(1);
        }
        this.myRepository = repository;
        this.myId = String.valueOf(data.getId());
        this.mySummary = data.getSummary();
        this.myDescription = data.getDescription();
        this.myProjectName = data.getProject() == null ? null : data.getProject().getName();
        this.myClosed = data.getStatus().getId().intValue() >= 90;
        this.myCreated = data.getDate_submitted().getTime();
        this.myUpdated = data.getLast_updated().getTime();
        this.myComments = data.getNotes() == null ? Comment.EMPTY_ARRAY : (Comment[])ContainerUtil.map2Array((Object[])data.getNotes(), Comment.class, data1 -> new Comment((IssueNoteData)data1){
            final /* synthetic */ IssueNoteData val$data1;
            {
                this.val$data1 = issueNoteData;
            }

            public String getText() {
                return this.val$data1.getText();
            }

            @Nullable
            public String getAuthor() {
                return this.val$data1.getReporter().getName();
            }

            @Nullable
            public Date getDate() {
                return this.val$data1.getDate_submitted().getTime();
            }
        });
    }

    public MantisTask(@NotNull IssueHeaderData header, @NotNull MantisRepository repository) {
        if (header == null) {
            MantisTask.$$$reportNull$$$0(2);
        }
        if (repository == null) {
            MantisTask.$$$reportNull$$$0(3);
        }
        this.myRepository = repository;
        this.myId = String.valueOf(header.getId());
        this.mySummary = header.getSummary();
        this.myProjectName = null;
        this.myClosed = header.getStatus().intValue() >= 90;
        this.myDescription = null;
        this.myCreated = null;
        this.myUpdated = header.getLast_updated().getTime();
        this.myComments = Comment.EMPTY_ARRAY;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            MantisTask.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = this.mySummary;
        if (string == null) {
            MantisTask.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public Comment[] getComments() {
        if (this.myComments == null) {
            MantisTask.$$$reportNull$$$0(6);
        }
        return this.myComments;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TasksCoreIcons.Mantis;
        if (icon == null) {
            MantisTask.$$$reportNull$$$0(7);
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        TaskType taskType = TaskType.OTHER;
        if (taskType == null) {
            MantisTask.$$$reportNull$$$0(8);
        }
        return taskType;
    }

    @Nullable
    public Date getUpdated() {
        return this.myUpdated;
    }

    @Nullable
    public Date getCreated() {
        return this.myCreated;
    }

    public boolean isClosed() {
        return this.myClosed;
    }

    public boolean isIssue() {
        return true;
    }

    public String getIssueUrl() {
        return this.myRepository.getUrl() + "/view.php?id=" + this.getId();
    }

    public TaskRepository getRepository() {
        return this.myRepository;
    }

    @Nullable
    public String getProject() {
        return this.myProjectName;
    }

    @NotNull
    public String getNumber() {
        String string = this.getId();
        if (string == null) {
            MantisTask.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/mantis/MantisTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/mantis/MantisTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

