/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.info.Info;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class LatestExistentSearcher {
    private static final Logger LOG = Logger.getInstance(LatestExistentSearcher.class);
    private long myStartNumber;
    private boolean myStartExistsKnown;
    @NotNull
    private final SVNURL myUrl;
    @NotNull
    private final SVNURL myRepositoryUrl;
    @NotNull
    private final String myRelativeUrl;
    private final SvnVcs myVcs;
    private long myEndNumber;

    public LatestExistentSearcher(SvnVcs vcs, @NotNull SVNURL url, @NotNull SVNURL repositoryUrl) {
        if (url == null) {
            LatestExistentSearcher.$$$reportNull$$$0(0);
        }
        if (repositoryUrl == null) {
            LatestExistentSearcher.$$$reportNull$$$0(1);
        }
        this(0L, -1L, false, vcs, url, repositoryUrl);
    }

    /*
     * WARNING - void declaration
     */
    public LatestExistentSearcher(long startNumber, long endNumber, boolean startExistsKnown, SvnVcs vcs, @NotNull SVNURL sVNURL, @NotNull SVNURL sVNURL2) {
        void repositoryUrl;
        void url;
        if (sVNURL == null) {
            LatestExistentSearcher.$$$reportNull$$$0(2);
        }
        if (sVNURL2 == null) {
            LatestExistentSearcher.$$$reportNull$$$0(3);
        }
        this.myStartNumber = startNumber;
        this.myEndNumber = endNumber;
        this.myStartExistsKnown = startExistsKnown;
        this.myVcs = vcs;
        this.myUrl = url;
        this.myRepositoryUrl = repositoryUrl;
        this.myRelativeUrl = SvnUtil.ensureStartSlash(SVNURLUtil.getRelativeURL((SVNURL)this.myRepositoryUrl, (SVNURL)this.myUrl, (boolean)true));
    }

    public long getDeletionRevision() {
        if (!this.detectStartRevision()) {
            return -1L;
        }
        Ref latest = new Ref((Object)this.myStartNumber);
        try {
            SVNURL existingParent;
            if (this.myEndNumber == -1L) {
                this.myEndNumber = this.getLatestRevision();
            }
            if ((existingParent = this.getExistingParent(this.myUrl)) == null) {
                return this.myStartNumber;
            }
            SVNRevision startRevision = SVNRevision.create((long)this.myStartNumber);
            SvnTarget target = SvnTarget.fromURL((SVNURL)existingParent, (SVNRevision)startRevision);
            this.myVcs.getFactory(target).createHistoryClient().doLog(target, startRevision, SVNRevision.HEAD, false, true, false, 0L, null, this.createHandler((Ref<Long>)latest));
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        return (Long)latest.get();
    }

    @NotNull
    private LogEntryConsumer createHandler(@NotNull Ref<Long> latest) {
        if (latest == null) {
            LatestExistentSearcher.$$$reportNull$$$0(4);
        }
        LogEntryConsumer logEntryConsumer = logEntry -> {
            if (latest == null) {
                LatestExistentSearcher.$$$reportNull$$$0(7);
            }
            Map<String, LogEntryPath> changedPaths = logEntry.getChangedPaths();
            for (LogEntryPath o : changedPaths.values()) {
                LogEntryPath path = o;
                if (path.getType() != 'D' || !this.myRelativeUrl.equals(path.getPath())) continue;
                latest.set((Object)logEntry.getRevision());
                throw new SVNException(SVNErrorMessage.UNKNOWN_ERROR_MESSAGE);
            }
        };
        if (logEntryConsumer == null) {
            LatestExistentSearcher.$$$reportNull$$$0(5);
        }
        return logEntryConsumer;
    }

    public long getLatestExistent() {
        if (!this.detectStartRevision()) {
            return this.myStartNumber;
        }
        long latestOk = this.myStartNumber;
        try {
            if (this.myEndNumber == -1L) {
                this.myEndNumber = this.getLatestRevision();
            }
            for (long i = this.myStartNumber + 1L; i < this.myEndNumber; ++i) {
                if (!this.existsInRevision(this.myUrl, i)) continue;
                latestOk = i;
            }
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        return latestOk;
    }

    private boolean detectStartRevision() {
        if (!this.myStartExistsKnown) {
            SvnFileUrlMapping mapping = this.myVcs.getSvnFileUrlMapping();
            RootUrlInfo rootUrlInfo = mapping.getWcRootForUrl(this.myUrl);
            if (rootUrlInfo == null) {
                return true;
            }
            VirtualFile vf = rootUrlInfo.getVirtualFile();
            Info info = this.myVcs.getInfo(vf);
            if (info == null || info.getRevision() == null) {
                return false;
            }
            this.myStartNumber = info.getRevision().getNumber();
            this.myStartExistsKnown = true;
        }
        return true;
    }

    @Nullable
    private SVNURL getExistingParent(SVNURL url) throws SvnBindException {
        while (url != null && !url.equals((Object)this.myRepositoryUrl) && !this.existsInRevision(url, this.myEndNumber)) {
            url = SvnUtil.removePathTail(url);
        }
        return url;
    }

    private boolean existsInRevision(@NotNull SVNURL url, long revisionNumber) throws SvnBindException {
        Info info;
        block3: {
            if (url == null) {
                LatestExistentSearcher.$$$reportNull$$$0(6);
            }
            SVNRevision revision = SVNRevision.create((long)revisionNumber);
            info = null;
            try {
                info = this.myVcs.getInfo(url, revision, revision);
            }
            catch (SvnBindException e) {
                if (e.contains(SVNErrorCode.RA_ILLEGAL_URL)) break block3;
                throw e;
            }
        }
        return info != null;
    }

    private long getLatestRevision() throws SvnBindException {
        return SvnUtil.getHeadRevision(this.myVcs, this.myRepositoryUrl).getNumber();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryUrl";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latest";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/LatestExistentSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/LatestExistentSearcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "existsInRevision";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createHandler$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

