/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import icons.SvnIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public enum ListMergeStatus {
    COMMON(SvnIcons.Common),
    MERGED(SvnIcons.Integrated),
    NOT_MERGED(SvnIcons.Notintegrated),
    ALIEN(null),
    REFRESHING(SvnIcons.IntegrationStatusUnknown);

    @Nullable
    private final Icon myIcon;

    private ListMergeStatus(Icon icon) {
        this.myIcon = icon;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ListMergeStatus from(@Nullable SvnMergeInfoCache.MergeCheckResult mergeCheckResult) {
        ListMergeStatus result = null;
        if (mergeCheckResult != null) {
            switch (mergeCheckResult) {
                case MERGED: {
                    result = MERGED;
                    break;
                }
                case COMMON: {
                    result = COMMON;
                    break;
                }
                default: {
                    result = NOT_MERGED;
                }
            }
        }
        return result;
    }
}

