/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class ExternalsDefinitionParser {
    @NotNull
    public static Map<String, String> parseExternalsProperty(@NotNull String externals) throws SvnBindException {
        if (externals == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(0);
        }
        HashMap map = ContainerUtil.newHashMap();
        for (String external : StringUtil.splitByLines((String)externals, (boolean)true)) {
            map.put(ExternalsDefinitionParser.parseRelativeDirectory(external), external);
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @NotNull
    public static String parseRelativeDirectory(@NotNull String s) throws SvnBindException {
        String result;
        int length;
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(2);
        }
        if (ExternalsDefinitionParser.isUnescapedQuote(s = s.trim(), (length = s.length()) - 1)) {
            int index = ExternalsDefinitionParser.lastUnescapedIndexOf(s, length - 1, '\"');
            ExternalsDefinitionParser.assertIndex(s, index, "Could not find start quote");
            result = s.substring(index + 1, length - 1);
        } else {
            int index = ExternalsDefinitionParser.lastUnescapedIndexOf(s, length, ' ');
            ExternalsDefinitionParser.assertIndex(s, index, "Could not find separating space");
            result = s.substring(index + 1);
        }
        String string = ExternalsDefinitionParser.unescape(result);
        if (string == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void assertIndex(@NotNull String s, int index, @NotNull String message) throws SvnBindException {
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(4);
        }
        if (message == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(5);
        }
        if (index < 0) {
            throw new SvnBindException(message + " - " + s);
        }
    }

    @NotNull
    private static String unescape(@NotNull String s) {
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(6);
        }
        String string = s.replace("\\", "");
        if (string == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static int lastUnescapedIndexOf(@NotNull String s, int from, char c) {
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(8);
        }
        int result = from;
        while ((result = s.lastIndexOf(c, result - 1)) != -1 && !ExternalsDefinitionParser.isUnescaped(s, result, c)) {
        }
        return result;
    }

    private static boolean isUnescapedQuote(@NotNull String s, int index) {
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(9);
        }
        return ExternalsDefinitionParser.isUnescaped(s, index, '\"');
    }

    private static boolean isUnescaped(@NotNull String s, int index, char c) {
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(10);
        }
        return StringUtil.isChar((CharSequence)s, (int)index, (char)c) && !StringUtil.isChar((CharSequence)s, (int)(index - 1), (char)'\\');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externals";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseExternalsProperty";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRelativeDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseExternalsProperty";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseRelativeDirectory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertIndex";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lastUnescapedIndexOf";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnescapedQuote";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnescaped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

