/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.ChangesBrowserDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTableModel;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesTableModel;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;

public class SvnSelectRevisionUtil {
    private SvnSelectRevisionUtil() {
    }

    @Nullable
    public static SvnChangeList chooseCommittedChangeList(Project project, SvnRepositoryLocation location, VirtualFile root) {
        try {
            SvnCommittedChangesTableModel model = new SvnCommittedChangesTableModel(location, project, root, SvnVcs.getInstance(project).getCommittedChangesProvider().getColumns());
            ChangesBrowserDialog dlg = new ChangesBrowserDialog(project, (CommittedChangesTableModel)model, ChangesBrowserDialog.Mode.Choose, null);
            if (dlg.showAndGet()) {
                return (SvnChangeList)dlg.getSelectedChangeList();
            }
            model.onBeforeClose();
        }
        catch (VcsException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)SvnBundle.message("error.cannot.load.revisions", new Object[0]));
        }
        return null;
    }
}

