/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;

class DummyDiffFragmentsProcessor {
    DummyDiffFragmentsProcessor() {
    }

    public ArrayList<LineFragment> process(String text1, String text2) {
        ArrayList<LineFragment> lineFragments = new ArrayList<LineFragment>();
        if (text1.isEmpty() && text2.isEmpty()) {
            return lineFragments;
        }
        TextDiffTypeEnum type = text1.isEmpty() ? TextDiffTypeEnum.INSERT : (text2.isEmpty() ? TextDiffTypeEnum.DELETED : TextDiffTypeEnum.CHANGED);
        lineFragments.add(new LineFragment(0, DummyDiffFragmentsProcessor.countLines(text1), 0, DummyDiffFragmentsProcessor.countLines(text2), type, new TextRange(0, text1.length()), new TextRange(0, text2.length())));
        return lineFragments;
    }

    private static int countLines(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        int count = StringUtil.countNewLines(text);
        if (text.charAt(text.length() - 1) != '\n') {
            ++count;
        }
        return count;
    }
}

