/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Key<T> {
    private static final AtomicInteger ourKeysCounter = new AtomicInteger();
    private final int myIndex;
    private final String myName;
    private static final ConcurrentIntObjectMap<Key> allKeys = ContainerUtil.createConcurrentIntObjectWeakValueMap();

    public Key(@NotNull @NonNls String name) {
        if (name == null) {
            Key.$$$reportNull$$$0(0);
        }
        this.myIndex = ourKeysCounter.getAndIncrement();
        this.myName = name;
        allKeys.put(this.myIndex, this);
    }

    public final int hashCode() {
        return this.myIndex;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public static <T> Key<T> create(@NotNull @NonNls String name) {
        if (name == null) {
            Key.$$$reportNull$$$0(1);
        }
        Key<T> key = new Key<T>(name);
        if (key == null) {
            Key.$$$reportNull$$$0(2);
        }
        return key;
    }

    public T get(@Nullable UserDataHolder holder) {
        return holder == null ? null : (T)holder.getUserData(this);
    }

    public T get(@Nullable Map<Key, ?> holder) {
        return holder == null ? null : (T)holder.get(this);
    }

    public T get(@Nullable UserDataHolder holder, T defaultValue) {
        T t = this.get(holder);
        return t == null ? defaultValue : t;
    }

    @NotNull
    public T getRequired(@NotNull UserDataHolder holder) {
        if (holder == null) {
            Key.$$$reportNull$$$0(3);
        }
        Object t = ObjectUtils.notNull(holder.getUserData(this));
        if (t == null) {
            Key.$$$reportNull$$$0(4);
        }
        return t;
    }

    public boolean isIn(@Nullable UserDataHolder holder) {
        return this.get(holder) != null;
    }

    public void set(@Nullable UserDataHolder holder, @Nullable T value) {
        if (holder != null) {
            holder.putUserData(this, value);
        }
    }

    public void set(@Nullable Map<Key, Object> holder, T value) {
        if (holder != null) {
            holder.put(this, value);
        }
    }

    @Nullable(value="can become null if the key has been gc-ed")
    public static <T> Key<T> getKeyByIndex(int index) {
        return allKeys.get(index);
    }

    @Nullable
    public static Key<?> findKeyByName(String name) {
        for (ConcurrentIntObjectMap.IntEntry<Key> key : allKeys.entries()) {
            if (!name.equals(key.getValue().myName)) continue;
            return key.getValue();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/Key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/Key";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequired";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRequired";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

