/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.run;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import com.jetbrains.rest.RestBundle;
import com.jetbrains.rest.run.RestRunConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestConfigurationEditor
extends SettingsEditor<RestRunConfiguration>
implements PanelWithAnchor {
    private JPanel myMainPanel;
    private JPanel myCommonOptionsPlaceholder;
    private TextFieldWithBrowseButton myInputFileField;
    private JTextField myParamsTextField;
    private JCheckBox myOpenInBrowser;
    private TextFieldWithBrowseButton myOutputFileField;
    private JComboBox myTasks;
    private JBLabel myCommandLabel;
    private JLabel myConfigurationName;
    private final AbstractPyCommonOptionsForm myCommonOptionsForm;
    private Project myProject;
    private JComponent anchor;

    public RestConfigurationEditor(Project project, AbstractPythonRunConfiguration configuration, CollectionComboBoxModel model) {
        this.$$$setupUI$$$();
        this.myCommonOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(configuration.getCommonOptionsFormData());
        this.myCommonOptionsPlaceholder.add(this.myCommonOptionsForm.getMainPanel());
        this.myProject = project;
        this.myTasks.setModel(model);
        this.myTasks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object task = RestConfigurationEditor.this.myTasks.getSelectedItem();
                if (task != null && (task.toString().equals("rst2latex") || task.toString().equals("rst2odt"))) {
                    RestConfigurationEditor.this.myOpenInBrowser.setEnabled(false);
                } else {
                    RestConfigurationEditor.this.myOpenInBrowser.setEnabled(true);
                }
            }
        });
        this.myOpenInBrowser.setSelected(false);
        this.setAnchor(this.myCommonOptionsForm.getAnchor());
    }

    protected void resetEditorFrom(@NotNull RestRunConfiguration configuration) {
        if (configuration == null) {
            RestConfigurationEditor.$$$reportNull$$$0(0);
        }
        AbstractPythonRunConfiguration.copyParams((AbstractPythonRunConfigurationParams)configuration, (AbstractPythonRunConfigurationParams)this.myCommonOptionsForm);
        this.myInputFileField.setText(configuration.getInputFile());
        this.myOutputFileField.setText(configuration.getOutputFile());
        this.myParamsTextField.setText(configuration.getParams());
        this.myTasks.setSelectedItem(configuration.getTask());
        this.myOpenInBrowser.setSelected(configuration.openInBrowser());
        if (configuration.getTask().equals("rst2latex") || configuration.getTask().equals("rst2odt")) {
            this.myOpenInBrowser.setEnabled(false);
        } else {
            this.myOpenInBrowser.setEnabled(true);
        }
    }

    protected void applyEditorTo(@NotNull RestRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            RestConfigurationEditor.$$$reportNull$$$0(1);
        }
        AbstractPythonRunConfiguration.copyParams((AbstractPythonRunConfigurationParams)this.myCommonOptionsForm, (AbstractPythonRunConfigurationParams)configuration);
        configuration.setInputFile(this.myInputFileField.getText().trim());
        configuration.setOutputFile(this.myOutputFileField.getText().trim());
        configuration.setParams(this.myParamsTextField.getText().trim());
        Object task = this.myTasks.getSelectedItem();
        if (task != null) {
            configuration.setTask(task.toString());
        }
        configuration.setOpenInBrowser(this.myOpenInBrowser.isSelected());
        if (!this.myOpenInBrowser.isEnabled()) {
            configuration.setOpenInBrowser(false);
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            RestConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public void setOpenInBrowserVisible(boolean visible) {
        this.myOpenInBrowser.setVisible(visible);
    }

    public void setInputDescriptor(FileChooserDescriptor descriptor) {
        String title = RestBundle.message((String)"runcfg.dlg.select.script.path", (Object[])new Object[0]);
        this.myInputFileField.addBrowseFolderListener(title, null, this.myProject, descriptor);
    }

    public void setOutputDescriptor(FileChooserDescriptor descriptor) {
        String title = RestBundle.message((String)"runcfg.dlg.select.script.path", (Object[])new Object[0]);
        this.myOutputFileField.addBrowseFolderListener(title, null, this.myProject, descriptor);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.anchor = anchor;
        this.myCommandLabel.setAnchor(anchor);
        this.myCommonOptionsForm.setAnchor(anchor);
    }

    public void setConfigurationName(String name) {
        this.myConfigurationName.setText(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/rest/run/RestConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/rest/run/RestConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JBLabel jBLabel;
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCommonOptionsPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/jetbrains/rest/RestBundle").getString("runcfg.docutils.input"));
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInputFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 2, 1, 1, 0, 1, 7, 1, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/jetbrains/rest/RestBundle").getString("runcfg.docutils.options"));
        jPanel2.add((Component)jLabel3, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParamsTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(4, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/jetbrains/rest/RestBundle").getString("runcfg.docutils.output"));
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 2, 1, 1, 0, 1, 7, 1, null, null, null));
        this.myOpenInBrowser = jCheckBox = new JCheckBox();
        jCheckBox.setText("Open output file in browser");
        jPanel2.add((Component)jCheckBox, new GridConstraints(5, 1, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myTasks = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myCommandLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/jetbrains/rest/RestBundle").getString("runcfg.docutils.command"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(20, -1), null));
        this.myConfigurationName = jLabel = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel.getFont());
        if (font != null) {
            jLabel.setFont(font);
        }
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, new Dimension(-1, 20), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

