/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.create;

import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.create.CreateResourceBundleDialogComponent;
import com.intellij.lang.properties.projectView.ResourceBundleAwareNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.Nullable;

public class AddNewPropertyFileAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(AddNewPropertyFileAction.class);

    protected AddNewPropertyFileAction() {
        super(PropertiesBundle.message("add.property.files.to.resource.bundle.dialog.action.title", new Object[0]), null, AllIcons.FileTypes.Properties);
    }

    public void update(AnActionEvent e) {
        ResourceBundle resourceBundle = AddNewPropertyFileAction.getResourceBundle(e);
        e.getPresentation().setEnabledAndVisible(resourceBundle != null && CreateResourceBundleDialogComponent.getResourceBundlePlacementDirectory(resourceBundle) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        ResourceBundle resourceBundle = AddNewPropertyFileAction.getResourceBundle(e);
        if (resourceBundle == null) {
            return;
        }
        new CreateResourceBundleDialogComponent.Dialog(e.getProject(), null, resourceBundle).show();
    }

    @Nullable
    private static ResourceBundle getResourceBundle(AnActionEvent e) {
        Navigatable[] data = (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(e.getDataContext());
        if (data == null || data.length != 1) {
            return null;
        }
        if (!(data[0] instanceof ResourceBundleAwareNode)) {
            return null;
        }
        return ((ResourceBundleAwareNode)data[0]).getResourceBundle();
    }
}

