/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.hyperlinks.LinkInfo;
import org.jetbrains.annotations.NotNull;

public class HyperlinkStyle
extends TextStyle
implements Runnable {
    @NotNull
    private final LinkInfo myLinkInfo;
    @NotNull
    private TextStyle myHighlightStyle;
    @NotNull
    HighlightMode myHighlightMode = HighlightMode.HOVER;

    public HyperlinkStyle(@NotNull TerminalColor foreground, @NotNull TerminalColor background, @NotNull LinkInfo hyperlinkInfo) {
        super(null, null);
        this.myHighlightStyle = new TextStyle(foreground, background);
        this.myHighlightStyle.setOption(TextStyle.Option.UNDERLINED, true);
        this.myLinkInfo = hyperlinkInfo;
    }

    @NotNull
    public HyperlinkStyle withHighlightMode(@NotNull HighlightMode mode) {
        this.myHighlightMode = mode;
        return this;
    }

    @Override
    public void run() {
        this.myLinkInfo.navigate();
    }

    @NotNull
    public TextStyle getHighlightStyle() {
        return this.myHighlightStyle;
    }

    @NotNull
    public LinkInfo getLinkInfo() {
        return this.myLinkInfo;
    }

    @NotNull
    public HighlightMode getHighlightMode() {
        return this.myHighlightMode;
    }

    public static enum HighlightMode {
        ALWAYS,
        NEVER,
        HOVER;

    }
}

