/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels.code;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodeOutputPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbErrorOutputCell;

public class IpnbErrorPanel
extends IpnbCodeOutputPanel<IpnbErrorOutputCell> {
    public IpnbErrorPanel(@NotNull IpnbErrorOutputCell cell, @Nullable IpnbCodePanel ipnbCodePanel) {
        if (cell == null) {
            IpnbErrorPanel.$$$reportNull$$$0(0);
        }
        super(cell, null, ipnbCodePanel);
    }

    @Override
    protected JComponent createViewPanel() {
        List<String> text = ((IpnbErrorOutputCell)this.myCell).getText();
        return IpnbErrorPanel.createColoredPanel(text);
    }

    @NotNull
    public static JComponent createColoredPanel(List<String> text) {
        if (text == null) {
            JLabel jLabel = new JLabel();
            if (jLabel == null) {
                IpnbErrorPanel.$$$reportNull$$$0(1);
            }
            return jLabel;
        }
        ColorPane ansiColoredPane = new ColorPane();
        Font font = ansiColoredPane.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize());
        ansiColoredPane.setFont(newFont);
        ansiColoredPane.appendANSI(StringUtil.join(text, (String)"\n"));
        ansiColoredPane.setBackground(IpnbEditorUtil.getBackground());
        ansiColoredPane.setEditable(false);
        ColorPane colorPane = ansiColoredPane;
        if (colorPane == null) {
            IpnbErrorPanel.$$$reportNull$$$0(2);
        }
        return colorPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbErrorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbErrorPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createColoredPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ColorPane
    extends JTextPane {
        static final Color D_Red = Color.decode("#8B0000");
        static final Color D_Magenta = JBColor.MAGENTA;
        static final Color D_Green = Color.decode("#006400");
        static final Color D_Yellow = Color.decode("#A52A2A");
        static final Color D_Cyan = Color.decode("#5AB4EB");
        static final Color cReset;
        static Color currentColor;
        String remaining = "";

        public void append(Color color, String s) {
            StyleContext styleContext = StyleContext.getDefaultStyleContext();
            AttributeSet attributeSet = styleContext.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color);
            int len = this.getDocument().getLength();
            this.setCaretPosition(len);
            this.setCharacterAttributes(attributeSet, false);
            this.replaceSelection(s);
        }

        public void appendANSI(String string) {
            int position = 0;
            String addString = this.remaining + string;
            this.remaining = "";
            if (addString.length() > 0) {
                String substring;
                if (this.handleCarriageReturn(addString)) {
                    return;
                }
                int index = addString.indexOf("\u001b");
                if (index == -1) {
                    this.append(currentColor, addString);
                    return;
                }
                if (index > 0) {
                    substring = addString.substring(0, index);
                    this.append(currentColor, substring);
                    position = index;
                }
                boolean continueSearch = true;
                while (continueSearch) {
                    int mIndex = addString.indexOf("m", position);
                    if (mIndex < 0) {
                        this.remaining = addString.substring(position, addString.length());
                        continueSearch = false;
                        continue;
                    }
                    substring = addString.substring(position, mIndex + 1);
                    currentColor = ColorPane.getANSIColor(substring);
                    position = mIndex + 1;
                    index = addString.indexOf("\u001b", position);
                    if (index == -1) {
                        substring = addString.substring(position, addString.length());
                        this.append(currentColor, substring);
                        continueSearch = false;
                        continue;
                    }
                    substring = addString.substring(position, index);
                    position = index;
                    this.append(currentColor, substring);
                }
            }
        }

        private boolean handleCarriageReturn(String addString) {
            int index = addString.indexOf("\r");
            if (index >= 0 && addString.length() > index + 1) {
                this.appendANSI(addString.substring(0, index));
                String substring = addString.substring(index + 1);
                Element element = this.getDocument().getDefaultRootElement();
                int position = this.getDocument().getLength();
                int line = element.getElementIndex(position);
                int offset = element.getElement(line).getStartOffset();
                try {
                    this.getDocument().remove(offset, this.getDocument().getLength() - offset);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                this.appendANSI(substring);
                return true;
            }
            return false;
        }

        public static Color getANSIColor(String ANSIColor) {
            if (ANSIColor.equals("\u001b[30m") || ANSIColor.equals("\u001b[0;30m") || ANSIColor.equals("\u001b[1;30m") || ANSIColor.equals("\u001b[01;30m")) {
                return JBColor.BLACK;
            }
            if (ANSIColor.equals("\u001b[31m") || ANSIColor.equals("\u001b[0;31m") || ANSIColor.equals("\u001b[1;31m") || ANSIColor.equals("\u001b[01;31m")) {
                return D_Red;
            }
            if (ANSIColor.equals("\u001b[32m") || ANSIColor.equals("\u001b[0;32m") || ANSIColor.equals("\u001b[1;32m") || ANSIColor.equals("\u001b[01;32m")) {
                return D_Green;
            }
            if (ANSIColor.equals("\u001b[33m") || ANSIColor.equals("\u001b[0;33m") || ANSIColor.equals("\u001b[1;33m") || ANSIColor.equals("\u001b[01;33m")) {
                return D_Yellow;
            }
            if (ANSIColor.equals("\u001b[34m") || ANSIColor.equals("\u001b[0;34m") || ANSIColor.equals("\u001b[1;34m") || ANSIColor.equals("\u001b[01;34m")) {
                return JBColor.BLUE;
            }
            if (ANSIColor.equals("\u001b[35m") || ANSIColor.equals("\u001b[0;35m") || ANSIColor.equals("\u001b[1;35m") || ANSIColor.equals("\u001b[01;35m")) {
                return D_Magenta;
            }
            if (ANSIColor.equals("\u001b[36m") || ANSIColor.equals("\u001b[0;36m") || ANSIColor.equals("\u001b[1;36m") || ANSIColor.equals("\u001b[01;36m")) {
                return D_Cyan;
            }
            if (ANSIColor.equals("\u001b[37m") || ANSIColor.equals("\u001b[0;37m") || ANSIColor.equals("\u001b[1;37m") || ANSIColor.equals("\u001b[01;37m")) {
                return JBColor.WHITE;
            }
            if (ANSIColor.equals("\u001b[0m")) {
                return cReset;
            }
            return JBColor.BLACK;
        }

        static {
            currentColor = cReset = JBColor.BLACK;
        }
    }
}

