/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSReplayPathHandler;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRepositoryUtil {
    public static final int MAX_KEY_SIZE = 200;
    private static final int BYTES_IN_LONG = 8;
    private static final byte[] BUFFER = new byte[8];
    private static final ThreadLocal<byte[]> ourCopyBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[16384];
        }
    };

    public static String generateLockToken() throws SVNException {
        String uuid = SVNUUIDGenerator.formatUUID(SVNUUIDGenerator.generateUUID());
        return "opaquelocktoken:" + uuid;
    }

    public static void replay(FSFS fsfs, FSRoot root, String basePath, long lowRevision, boolean sendDeltas, ISVNEditor editor) throws SVNException {
        Map fsChanges = root.getChangedPaths();
        basePath = basePath.startsWith("/") ? basePath.substring(1) : basePath;
        LinkedList<String> interestingPaths = new LinkedList<String>();
        SVNHashMap changedPaths = new SVNHashMap();
        for (String path : fsChanges.keySet()) {
            FSPathChange change = (FSPathChange)fsChanges.get(path);
            String string = path = path.startsWith("/") ? path.substring(1) : path;
            if (SVNPathUtil.isWithinBasePath(basePath, path)) {
                interestingPaths.add(path);
                changedPaths.put(path, change);
                continue;
            }
            if (!SVNPathUtil.isWithinBasePath(path, basePath)) continue;
            interestingPaths.add(path);
            changedPaths.put(path, change);
        }
        if (FSRepository.isInvalidRevision(lowRevision)) {
            lowRevision = 0L;
        }
        FSRevisionRoot compareRoot = null;
        if (sendDeltas) {
            long revision = -1L;
            if (root instanceof FSRevisionRoot) {
                FSRevisionRoot revRoot = (FSRevisionRoot)root;
                revision = revRoot.getRevision() - 1L;
            } else if (root instanceof FSTransactionRoot) {
                FSTransactionRoot txnRoot = (FSTransactionRoot)root;
                revision = txnRoot.getTxn().getBaseRevision();
            }
            compareRoot = fsfs.createRevisionRoot(revision);
        }
        if (root instanceof FSRevisionRoot) {
            FSRevisionRoot revRoot = (FSRevisionRoot)root;
            editor.targetRevision(revRoot.getRevision());
        }
        FSReplayPathHandler handler = new FSReplayPathHandler(fsfs, root, compareRoot, changedPaths, basePath, lowRevision);
        SVNCommitUtil.driveCommitEditor(handler, interestingPaths, editor, -1L);
    }

    public static void copy(InputStream src, OutputStream dst, ISVNCanceller canceller) throws SVNException {
        try {
            int length;
            byte[] buffer = ourCopyBuffer.get();
            do {
                if (canceller != null) {
                    canceller.checkCancelled();
                }
                if ((length = src.read(buffer)) <= 0) continue;
                dst.write(buffer, 0, length);
            } while (length >= 0);
        }
        catch (IOExceptionWrapper ioew) {
            throw ioew.getOriginalException();
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
    }

    public static boolean arePropertiesEqual(FSRevisionNode revNode1, FSRevisionNode revNode2) {
        return FSRepositoryUtil.areRepresentationsEqual(revNode1, revNode2, true);
    }

    public static boolean arePropertiesChanged(FSRoot root1, String path1, FSRoot root2, String path2) throws SVNException {
        FSRevisionNode node2;
        FSRevisionNode node1 = root1.getRevisionNode(path1);
        return !FSRepositoryUtil.areRepresentationsEqual(node1, node2 = root2.getRevisionNode(path2), true);
    }

    public static boolean areFileContentsChanged(FSRoot root1, String path1, FSRoot root2, String path2) throws SVNException {
        FSRevisionNode revNode2;
        FSRevisionNode revNode1;
        SVNErrorMessage err;
        if (root1.checkNodeKind(path1) != SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "''{0}'' is not a file", (Object)path1);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (root2.checkNodeKind(path2) != SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "''{0}'' is not a file", (Object)path2);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return !FSRepositoryUtil.areRepresentationsEqual(revNode1 = root1.getRevisionNode(path1), revNode2 = root2.getRevisionNode(path2), false);
    }

    public static SVNProperties getPropsDiffs(SVNProperties sourceProps, SVNProperties targetProps) {
        SVNProperties result = new SVNProperties();
        if (sourceProps == null) {
            sourceProps = new SVNProperties();
        }
        if (targetProps == null) {
            targetProps = new SVNProperties();
        }
        for (String propName : sourceProps.nameSet()) {
            SVNPropertyValue srcPropVal = sourceProps.getSVNPropertyValue(propName);
            SVNPropertyValue targetPropVal = targetProps.getSVNPropertyValue(propName);
            if (targetPropVal == null) {
                result.put(propName, targetPropVal);
                continue;
            }
            if (targetPropVal.equals(srcPropVal)) continue;
            result.put(propName, targetPropVal);
        }
        for (String propName : targetProps.nameSet()) {
            SVNPropertyValue targetPropVal = targetProps.getSVNPropertyValue(propName);
            SVNPropertyValue sourceValue = sourceProps.getSVNPropertyValue(propName);
            if (sourceValue != null) continue;
            result.put(propName, targetPropVal);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkFilesDifferent(FSRoot root1, String path1, FSRoot root2, String path2, SVNDeltaCombiner deltaCombiner) throws SVNException {
        changed = FSRepositoryUtil.areFileContentsChanged(root1, path1, root2, path2);
        if (!changed) {
            return false;
        }
        revNode1 = root1.getRevisionNode(path1);
        revNode2 = root2.getRevisionNode(path2);
        if (revNode1.getFileLength() != revNode2.getFileLength()) {
            return true;
        }
        if (!revNode1.getFileMD5Checksum().equals(revNode2.getFileMD5Checksum())) {
            return true;
        }
        file1IS = null;
        file2IS = null;
        try {
            file1IS = root1.getFileStreamForPath(deltaCombiner, path1);
            file2IS = root2.getFileStreamForPath(deltaCombiner, path2);
            r1 = -1;
            r2 = -1;
            while (true) {
                r1 = file1IS.read();
                if (r1 == (r2 = file2IS.read())) continue;
                var12_14 = true;
                ** GOTO lbl31
                break;
            }
        }
        catch (IOException ioe) {
            try {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
            }
            catch (Throwable var13_15) {
                SVNFileUtil.closeFile(file1IS);
                SVNFileUtil.closeFile(file2IS);
                throw var13_15;
            }
lbl31:
            // 1 sources

            SVNFileUtil.closeFile(file1IS);
            SVNFileUtil.closeFile(file2IS);
            return var12_14;
            {
                if (r1 != -1) ** continue;
            }
            SVNFileUtil.closeFile(file1IS);
            SVNFileUtil.closeFile(file2IS);
            return false;
            SVNFileUtil.closeFile(file1IS);
            SVNFileUtil.closeFile(file2IS);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendTextDelta(ISVNEditor editor, String editPath, String sourcePath, String hexDigest, FSRevisionRoot sourceRoot, String targetPath, FSRoot targetRoot, boolean sendDeltas, SVNDeltaCombiner deltaCombiner, SVNDeltaGenerator deltaGenerator, FSFS fsfs) throws SVNException {
        block3: {
            block2: {
                editor.applyTextDelta(editPath, hexDigest);
                if (!sendDeltas) break block2;
                InputStream sourceStream = null;
                InputStream targetStream = null;
                try {
                    sourceStream = sourceRoot != null && sourcePath != null ? sourceRoot.getFileStreamForPath(deltaCombiner, sourcePath) : FSInputStream.createDeltaStream(deltaCombiner, (FSRevisionNode)null, fsfs);
                    targetStream = targetRoot.getFileStreamForPath(deltaCombiner, targetPath);
                    deltaGenerator.sendDelta(editPath, sourceStream, 0L, targetStream, editor, false);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(sourceStream);
                    SVNFileUtil.closeFile(targetStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile(sourceStream);
                SVNFileUtil.closeFile(targetStream);
                break block3;
            }
            editor.textDeltaChunk(editPath, SVNDiffWindow.EMPTY);
            editor.textDeltaEnd(editPath);
        }
    }

    public static void loadRootChangesOffsetLogicalAddressing(FSFS fsfs, long revision, FSFile file, long index, long[] rootOffset, long[] changesOffset) throws SVNException {
        long offset = fsfs.lookupOffsetInIndex(file, revision, index);
        if (rootOffset != null) {
            rootOffset[0] = offset;
        }
        if (changesOffset != null) {
            changesOffset[0] = offset;
        }
    }

    public static void loadRootChangesOffset(FSFS fsfs, long revision, FSFile file, long[] rootOffset, long[] changesOffset) throws SVNException {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        long offset = 0L;
        offset = fsfs.isPackedRevision(revision) && (revision + 1L) % fsfs.getMaxFilesPerDirectory() != 0L ? fsfs.getPackedOffset(revision + 1L) : file.size();
        long revOffset = 0L;
        if (fsfs.isPackedRevision(revision)) {
            revOffset = fsfs.getPackedOffset(revision);
        }
        file.seek(offset - 64L);
        try {
            file.read(buffer);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, e, SVNLogType.FSFS);
        }
        buffer.flip();
        if (buffer.get(buffer.limit() - 1) != 10) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Revision file lacks trailing newline");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        int spaceIndex = -1;
        int eolIndex = -1;
        for (int i = buffer.limit() - 2; i >= 0; --i) {
            byte b = buffer.get(i);
            if (b == 32 && spaceIndex < 0) {
                spaceIndex = i;
                continue;
            }
            if (b != 10 || eolIndex >= 0) continue;
            eolIndex = i;
            break;
        }
        if (eolIndex < 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file longer than 64 characters");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (spaceIndex < 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file missing space");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        try {
            buffer.limit(buffer.limit() - 1);
            buffer.position(spaceIndex + 1);
            String line = decoder.decode(buffer).toString();
            if (changesOffset != null && changesOffset.length > 0) {
                changesOffset[0] = revOffset + Long.parseLong(line);
            }
            buffer.limit(spaceIndex);
            buffer.position(eolIndex + 1);
            line = decoder.decode(buffer).toString();
            if (rootOffset != null && rootOffset.length > 0) {
                rootOffset[0] = revOffset + Long.parseLong(line);
            }
        }
        catch (NumberFormatException nfe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file missing changes and root offsets");
            SVNErrorManager.error(err, nfe, SVNLogType.FSFS);
        }
        catch (CharacterCodingException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file missing changes and root offsets");
            SVNErrorManager.error(err, e, SVNLogType.FSFS);
        }
    }

    public static String generateNextKey(String oldKey) throws SVNException {
        char[] nextKey = new char[oldKey.length() + 1];
        boolean carry = true;
        if (oldKey.length() > 1 && oldKey.charAt(0) == '0') {
            return null;
        }
        for (int i = oldKey.length() - 1; i >= 0; --i) {
            char c = oldKey.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z')) {
                return null;
            }
            if (carry) {
                if (c == 'z') {
                    nextKey[i] = 48;
                    continue;
                }
                carry = false;
                if (c == '9') {
                    nextKey[i] = 97;
                    continue;
                }
                nextKey[i] = (char)(c + '\u0001');
                continue;
            }
            nextKey[i] = c;
        }
        int nextKeyLength = oldKey.length() + (carry ? 1 : 0);
        if (nextKeyLength >= 200) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: new key length is greater than the threshold {0}", (Object)new Integer(200));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (carry) {
            System.arraycopy(nextKey, 0, nextKey, 1, oldKey.length());
            nextKey[0] = 49;
        }
        return new String(nextKey, 0, nextKeyLength);
    }

    public static void checkReposDBFormat(int format) throws SVNException {
        SVNErrorMessage err;
        if (format == 5) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_UNSUPPORTED_FORMAT, "Found format '%s', only created by unreleased dev builds; see http://subversion.apache.org/docs/release-notes/1.7#revprop-packing", (Object)new Integer(5));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (format < 1 || format > 7) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_UNSUPPORTED_FORMAT, "Expected FS format between ''{0}'' and ''{1}''; found format ''{2}''", new Integer(1), new Integer(7), new Integer(format));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }

    public static void validateProperty(String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if (!SVNProperty.isRegularProperty(propertyName)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Storage of non-regular property ''{0}'' is disallowed through the repository interface, and could indicate a bug in your client", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (SVNProperty.isSVNProperty(propertyName) && propertyValue != null && "svn:date".equals(propertyName)) {
            try {
                SVNDate.parseDateString(propertyValue.getString());
            }
            catch (SVNException svne) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_PROPERTY_VALUE);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
    }

    public static long align(long size, long boundary) {
        return size + boundary - 1L & (boundary - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long readLongLittleEndian(RandomAccessFile randomAccessFile) throws IOException {
        int bytesRead = randomAccessFile.read(BUFFER, 0, 8);
        if (bytesRead < 0) {
            return bytesRead;
        }
        long value = 0L;
        for (int i = 7; i >= 0; --i) {
            value = (value << 8) + ((long)BUFFER[i] & 0xFFL);
        }
        return value;
    }

    public static void writeLongLittleEndian(RandomAccessFile randomAccessFile, long value) throws IOException {
        for (int i = 0; i < 8; ++i) {
            FSRepositoryUtil.BUFFER[i] = (byte)value;
            value >>= 8;
        }
        randomAccessFile.write(BUFFER, 0, 8);
    }

    public static int encodeInt(byte[] bytes, long value) {
        return FSRepositoryUtil.encodeUnsignedInt(bytes, value < 0L ? -1L - 2L * value : 2L * value);
    }

    public static int encodeUnsignedInt(byte[] bytes, long value) {
        value &= 0xFFFFFFFFL;
        int i = 0;
        while (value >= 128L) {
            bytes[i] = (byte)(value % 128L + 128L);
            value /= 128L;
            ++i;
        }
        bytes[i] = (byte)(value % 128L);
        return i + 1;
    }

    private static boolean areRepresentationsEqual(FSRevisionNode revNode1, FSRevisionNode revNode2, boolean forProperties) {
        if (revNode1 == revNode2) {
            return true;
        }
        if (revNode1 == null || revNode2 == null) {
            return false;
        }
        return FSRepresentation.compareRepresentations(forProperties ? revNode1.getPropsRepresentation() : revNode1.getTextRepresentation(), forProperties ? revNode2.getPropsRepresentation() : revNode2.getTextRepresentation());
    }
}

