/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgAbstractFilesAction;
import org.zmlx.hg4idea.command.HgResolveCommand;

public class HgMarkResolved
extends HgAbstractFilesAction {
    @Override
    protected boolean isEnabled(Project project, HgVcs vcs, VirtualFile file) {
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
        return fileStatus != null && FileStatus.MERGED_WITH_CONFLICTS.equals(fileStatus);
    }

    @Override
    protected void batchPerform(Project project, HgVcs activeVcs, List<VirtualFile> files, DataContext context) {
        HgResolveCommand resolveCommand = new HgResolveCommand(project);
        for (VirtualFile file : files) {
            VirtualFile root = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)file);
            if (root == null) {
                return;
            }
            resolveCommand.markResolved(root, file);
        }
    }
}

