/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LexerPositionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredLexer
extends DelegateLexer {
    public static ThreadLocal<Boolean> ourDisableLayersFlag = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lexer.LayeredLexer");
    private static final int IN_LAYER_STATE = 1024;
    private static final int IN_LAYER_LEXER_FINISHED_STATE = 2048;
    private int myState;
    private final Map<IElementType, Lexer> myStartTokenToLayerLexer = new HashMap();
    private Lexer myCurrentLayerLexer;
    private IElementType myCurrentBaseTokenType;
    private int myLayerLeftPart = -1;
    private int myBaseTokenEnd = -1;
    private final HashSet<Lexer> mySelfStoppingLexers = new HashSet(1);
    private final HashMap<Lexer, IElementType[]> myStopTokens = new HashMap(1);

    public LayeredLexer(Lexer baseLexer) {
        super(baseLexer);
    }

    public void registerSelfStoppingLayer(Lexer lexer, IElementType[] startTokens, IElementType[] stopTokens) {
        if (Boolean.TRUE.equals(ourDisableLayersFlag.get())) {
            return;
        }
        this.registerLayer(lexer, startTokens);
        this.mySelfStoppingLexers.add(lexer);
        this.myStopTokens.put((Object)lexer, (Object)stopTokens);
    }

    public void registerLayer(Lexer lexer, IElementType ... startTokens) {
        if (Boolean.TRUE.equals(ourDisableLayersFlag.get())) {
            return;
        }
        for (IElementType startToken : startTokens) {
            LOG.assertTrue(!this.myStartTokenToLayerLexer.containsKey(startToken));
            this.myStartTokenToLayerLexer.put(startToken, lexer);
        }
    }

    private void activateLayerIfNecessary() {
        IElementType baseTokenType = super.getTokenType();
        this.myCurrentLayerLexer = this.findLayerLexer(baseTokenType);
        if (this.myCurrentLayerLexer != null) {
            this.myCurrentBaseTokenType = baseTokenType;
            this.myBaseTokenEnd = super.getTokenEnd();
            this.myCurrentLayerLexer.start(super.getBufferSequence(), super.getTokenStart(), super.getTokenEnd());
            if (this.mySelfStoppingLexers.contains(this.myCurrentLayerLexer)) {
                super.advance();
            }
        }
    }

    @Nullable
    protected Lexer findLayerLexer(IElementType baseTokenType) {
        return this.myStartTokenToLayerLexer.get(baseTokenType);
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            LayeredLexer.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(initialState != 1024, (Object)"Restoring to layer is not supported.");
        this.myState = initialState;
        this.myCurrentLayerLexer = null;
        super.start(buffer, startOffset, endOffset, initialState);
        this.activateLayerIfNecessary();
    }

    @Override
    public int getState() {
        return this.myState;
    }

    @Override
    public IElementType getTokenType() {
        if (this.isInLayerEndGap()) {
            return this.myCurrentBaseTokenType;
        }
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenType() : super.getTokenType();
    }

    @Override
    public int getTokenStart() {
        if (this.isInLayerEndGap()) {
            return this.myLayerLeftPart;
        }
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenStart() : super.getTokenStart();
    }

    @Override
    public int getTokenEnd() {
        if (this.isInLayerEndGap()) {
            return this.myBaseTokenEnd;
        }
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenEnd() : super.getTokenEnd();
    }

    @Override
    public void advance() {
        if (this.isInLayerEndGap()) {
            this.myLayerLeftPart = -1;
            this.myState = super.getState();
            return;
        }
        if (this.isLayerActive()) {
            Lexer activeLayerLexer = this.myCurrentLayerLexer;
            IElementType layerTokenType = activeLayerLexer.getTokenType();
            if (!this.isStopToken(this.myCurrentLayerLexer, layerTokenType)) {
                this.myCurrentLayerLexer.advance();
                layerTokenType = this.myCurrentLayerLexer.getTokenType();
            } else {
                layerTokenType = null;
            }
            if (layerTokenType == null) {
                int tokenEnd = this.myCurrentLayerLexer.getTokenEnd();
                if (!this.mySelfStoppingLexers.contains(this.myCurrentLayerLexer)) {
                    this.myCurrentLayerLexer = null;
                    super.advance();
                    this.activateLayerIfNecessary();
                } else {
                    this.myCurrentLayerLexer = null;
                    if (tokenEnd != this.myBaseTokenEnd) {
                        this.myState = 2048;
                        this.myLayerLeftPart = tokenEnd;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("We've got not covered gap from layered lexer: " + activeLayerLexer + "\n on token: " + this.getBufferSequence().subSequence(this.myLayerLeftPart, this.myBaseTokenEnd));
                        }
                        return;
                    }
                }
            }
        } else {
            super.advance();
            this.activateLayerIfNecessary();
        }
        this.myState = this.isLayerActive() ? 1024 : super.getState();
    }

    @Override
    @NotNull
    public LexerPosition getCurrentPosition() {
        LexerPositionImpl lexerPositionImpl = new LexerPositionImpl(this.getTokenStart(), this.getState());
        if (lexerPositionImpl == null) {
            LayeredLexer.$$$reportNull$$$0(1);
        }
        return lexerPositionImpl;
    }

    @Override
    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            LayeredLexer.$$$reportNull$$$0(2);
        }
        this.start(this.getBufferSequence(), position.getOffset(), this.getBufferEnd(), position.getState());
    }

    private boolean isStopToken(Lexer lexer, IElementType tokenType) {
        IElementType[] stopTokens = (IElementType[])this.myStopTokens.get((Object)lexer);
        if (stopTokens == null) {
            return false;
        }
        for (IElementType stopToken : stopTokens) {
            if (stopToken != tokenType) continue;
            return true;
        }
        return false;
    }

    protected boolean isLayerActive() {
        return this.myCurrentLayerLexer != null;
    }

    private boolean isInLayerEndGap() {
        return this.myLayerLeftPart != -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/LayeredLexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/LayeredLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

