/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedComboBoxEditor
implements ComboBoxEditor {
    @NotNull
    private final JBTextField myField = UIUtil.isUnderDefaultMacTheme() ? new MacComboBoxTextField() : new JBTextField();
    private Object oldValue;

    @NotNull
    public JBTextField getField() {
        JBTextField jBTextField = this.myField;
        if (jBTextField == null) {
            FixedComboBoxEditor.$$$reportNull$$$0(0);
        }
        return jBTextField;
    }

    @Override
    public Component getEditorComponent() {
        return this.myField;
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject != null) {
            this.myField.setText(anObject.toString());
            this.oldValue = anObject;
        } else {
            this.myField.setText("");
        }
    }

    @Override
    public Object getItem() {
        Object newValue = this.myField.getText();
        if (this.oldValue != null && !(this.oldValue instanceof String)) {
            if (newValue.equals(this.oldValue.toString())) {
                return this.oldValue;
            }
            Class<?> cls = this.oldValue.getClass();
            try {
                Method method = cls.getMethod("valueOf", String.class);
                newValue = method.invoke(this.oldValue, this.myField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newValue;
    }

    @Override
    public void selectAll() {
        this.myField.selectAll();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myField, true));
    }

    @Override
    public void addActionListener(ActionListener l) {
    }

    @Override
    public void removeActionListener(ActionListener l) {
    }

    @Nullable
    private static ComboPopup getComboboxPopup(JComboBox comboBox) {
        ComboBoxUI ui = comboBox.getUI();
        ComboPopup popup = null;
        if (ui instanceof BasicComboBoxUI) {
            popup = (ComboPopup)ReflectionUtil.getField(BasicComboBoxUI.class, (Object)ui, ComboPopup.class, (String)"popup");
        }
        return popup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/FixedComboBoxEditor", "getField"));
    }

    private class MacComboBoxTextField
    extends JBTextField
    implements DocumentListener,
    FocusListener {
        private MacComboBoxTextField() {
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke("DOWN"), "aquaSelectNext");
            inputMap.put(KeyStroke.getKeyStroke("KP_DOWN"), "aquaSelectNext");
            inputMap.put(KeyStroke.getKeyStroke("UP"), "aquaSelectPrevious");
            inputMap.put(KeyStroke.getKeyStroke("KP_UP"), "aquaSelectPrevious");
            inputMap.put(KeyStroke.getKeyStroke("HOME"), "aquaSelectHome");
            inputMap.put(KeyStroke.getKeyStroke("END"), "aquaSelectEnd");
            inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), "aquaSelectPageUp");
            inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "aquaSelectPageDown");
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), "aquaEnterPressed");
            inputMap.put(KeyStroke.getKeyStroke("SPACE"), "aquaSpacePressed");
            this.addFocusListener(this);
        }

        @Override
        public boolean hasFocus() {
            Container parent = this.getParent();
            if (parent instanceof ComboBox && ((ComboBox)parent).myPaintingNow) {
                return false;
            }
            return super.hasFocus();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.repaintCombobox();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.repaintCombobox();
        }

        private void repaintCombobox() {
            Container parent = this.getParent();
            if (parent == null || parent instanceof JComponent && Boolean.TRUE == ((JComponent)parent).getClientProperty("JComboBox.isTableCellEditor")) {
                return;
            }
            Container grandParent = parent.getParent();
            if (grandParent != null) {
                grandParent.repaint();
            }
        }

        @Override
        public Color getBackground() {
            Container parent;
            if (UIUtil.isUnderDefaultMacTheme() && (parent = this.getParent()) != null && !parent.isEnabled()) {
                return Gray.xF8;
            }
            return super.getBackground();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            Container ancestor = SwingUtilities.getAncestorOfClass(JComboBox.class, this);
            if (ancestor == null || !ancestor.isVisible()) {
                return;
            }
            JComboBox comboBox = (JComboBox)ancestor;
            if (!comboBox.isPopupVisible()) {
                return;
            }
            ComboPopup popup = FixedComboBoxEditor.getComboboxPopup(comboBox);
            if (popup == null) {
                return;
            }
            String s = FixedComboBoxEditor.this.myField.getText();
            ComboBoxModel listmodel = comboBox.getModel();
            int i = listmodel.getSize();
            if (s.length() > 0) {
                for (int j = 0; j < i; ++j) {
                    String s1;
                    Object obj = listmodel.getElementAt(j);
                    if (obj == null || (s1 = obj.toString()) == null || !s1.startsWith(s) && !s1.equals(s)) continue;
                    popup.getList().setSelectedIndex(j);
                    return;
                }
            }
            popup.getList().clearSelection();
        }
    }
}

