/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ClickListener;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldAction
extends AnAction
implements CustomComponentAction {
    protected JTextField myField;
    private final String myDescription;
    private final Icon myIcon;

    protected TextFieldAction(String text, String description, Icon icon, int initSize) {
        super(text, description, icon);
        this.myDescription = description;
        this.myIcon = icon;
        this.myField = new JTextField(initSize);
        this.myField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    TextFieldAction.this.actionPerformed(null);
                }
            }
        });
    }

    @Override
    public abstract void actionPerformed(@Nullable AnActionEvent var1);

    @Override
    public JComponent createCustomComponent(Presentation presentation) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(this.myIcon);
        label.setOpaque(true);
        label.setBackground(this.myField.getBackground());
        this.myField.setOpaque(true);
        panel.add((Component)this.myField, "West");
        panel.add((Component)label, "East");
        this.myField.setToolTipText(this.myDescription);
        label.setToolTipText(this.myDescription);
        Border originalBorder = SystemInfo.isMac ? BorderFactory.createLoweredBevelBorder() : this.myField.getBorder();
        panel.setBorder(new CompoundBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)4, (int)0), originalBorder));
        this.myField.setOpaque(true);
        this.myField.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)5));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                TextFieldAction.this.actionPerformed(null);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/ui/TextFieldAction$2", "onClick"));
            }
        }.installOn((Component)label);
        return panel;
    }
}

